/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.time;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.layer.ActiveAnimation;
import org.zeith.hammeranims.api.time.TimeFunction;
import org.zeith.hammeranims.api.utils.ICompoundSerializable;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammeranims.core.utils.InstanceHelpers;

public class TimeFunctionInstance
implements ICompoundSerializable {
    public static final TimeFunctionInstance EMPTY = new TimeFunctionInstance(DefaultsHA.LINEAR_TIME);
    private CompoundTag extra;
    protected final TimeFunction function;

    public TimeFunctionInstance(TimeFunction function) {
        this.function = function;
    }

    public final boolean isEmpty() {
        return this.function == DefaultsHA.LINEAR_TIME;
    }

    public double getTime(AnimationSystem system, double sysTime, float partialTicks, ActiveAnimation animation) {
        return this.function.getTime(system, sysTime, partialTicks, animation, this);
    }

    public double getLengthSeconds(ActiveAnimation animation) {
        return this.function.getLengthSeconds(animation, this);
    }

    @Nonnull
    public static TimeFunctionInstance of(CompoundTag tag) {
        TimeFunction action = (TimeFunction)HammerAnimationsApi.timeFunctions().getValue(new ResourceLocation(tag.m_128461_("Id")));
        return action == null || action == DefaultsHA.LINEAR_TIME ? EMPTY : action.deserializeInstance(tag);
    }

    public CompoundTag getExtra() {
        CompoundTag i = InstanceHelpers.newNBTCompound();
        if (this.extra == null && !this.isEmpty()) {
            this.extra = i;
        }
        return i;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = InstanceHelpers.newNBTCompound();
        if (this.extra != null) {
            tag.m_128365_("Extra", (Tag)this.extra);
        }
        tag.m_128359_("Id", this.function.getRegistryKey().toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("Extra", 10)) {
            this.extra = nbt.m_128469_("Extra");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeFunctionInstance that = (TimeFunctionInstance)o;
        return Objects.equals(this.extra, that.extra) && Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hash(this.extra, this.function);
    }
}

