/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.time;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.animation.LoopMode;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.layer.ActiveAnimation;
import org.zeith.hammeranims.api.time.TimeFunctionInstance;

public abstract class TimeFunction {
    public abstract double computeTime(AnimationSystem var1, double var2, float var4, ActiveAnimation var5, TimeFunctionInstance var6);

    @Nonnull
    protected TimeFunctionInstance createInstance() {
        return new TimeFunctionInstance(this);
    }

    public TimeFunctionInstance defaultInstance() {
        return this.createInstance();
    }

    @Nonnull
    public TimeFunctionInstance deserializeInstance(CompoundTag tag) {
        TimeFunctionInstance inst = this.createInstance();
        inst.deserializeNBT(tag);
        return inst;
    }

    public double getLengthSeconds(ActiveAnimation animation, TimeFunctionInstance instance) {
        return animation.config.animation.getData().getLengthSeconds();
    }

    public double getTime(AnimationSystem system, double sysTime, float partialTicks, ActiveAnimation animation, TimeFunctionInstance instance) {
        double time = this.computeTime(system, sysTime, partialTicks, animation, instance);
        if (animation.config.animation != null) {
            LoopMode mode = animation.config.loopMode;
            double duration = this.getLengthSeconds(animation, instance);
            if (animation.config.reverse) {
                switch (mode) {
                    case LOOP: {
                        return duration > 0.0 ? duration - time % duration : 0.0;
                    }
                    case HOLD_ON_LAST_FRAME: {
                        return Math.max(duration - time, (double)1.0E-30f);
                    }
                    case ONCE: {
                        return duration - time;
                    }
                }
            }
            switch (mode) {
                case LOOP: {
                    return duration > 0.0 ? time % duration : 0.0;
                }
                case HOLD_ON_LAST_FRAME: {
                    return Math.min(time, duration);
                }
                case ONCE: {
                    return time;
                }
            }
        }
        return time;
    }

    public final ResourceLocation getRegistryKey() {
        return HammerAnimationsApi.timeFunctions().getKey((Object)this);
    }
}

