/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.particles.event;

import java.util.Map;
import java.util.function.Function;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.api.particles.ParticleEffect;
import org.zeith.hammeranims.api.particles.components.IParticleComponent;
import org.zeith.hammeranims.api.particles.components.IParticleComponentType;

public class CreateParticleEffectEvent
extends Event {
    protected final IParticleContainer container;
    protected final Map<IParticleComponentType, IParticleComponent> components;
    protected final ParticleEffect.Builder builder;

    public CreateParticleEffectEvent(IParticleContainer container, Map<IParticleComponentType, IParticleComponent> components, ParticleEffect.Builder builder) {
        this.container = container;
        this.components = components;
        this.builder = builder;
    }

    public IParticleContainer getContainer() {
        return this.container;
    }

    public Map<IParticleComponentType, IParticleComponent> getComponents() {
        return this.components;
    }

    public ParticleEffect.Builder getBuilder() {
        return this.builder;
    }

    public IParticleComponent get(IParticleComponentType type) {
        return this.components.get(type);
    }

    public IParticleComponent getOrCreate(IParticleComponentType type, Function<IParticleComponentType, IParticleComponent> factory) {
        return this.components.computeIfAbsent(type, factory);
    }
}

