/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.particles.emitter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammeranims.api.particles.ParticleEffect;
import org.zeith.hammeranims.api.particles.components.itf.IEmitterInitialize;
import org.zeith.hammeranims.api.particles.components.itf.IEmitterUpdate;
import org.zeith.hammeranims.api.particles.components.itf.IParticleExpiry;
import org.zeith.hammeranims.api.particles.components.itf.IParticleInitialize;
import org.zeith.hammeranims.api.particles.components.itf.IParticlePostRender;
import org.zeith.hammeranims.api.particles.components.itf.IParticlePreRender;
import org.zeith.hammeranims.api.particles.components.itf.IParticleRender;
import org.zeith.hammeranims.api.particles.components.itf.IParticleUpdate;
import org.zeith.hammeranims.api.particles.curve.ParticleCurve;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.emitter.IParticleRotationUpdater;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;
import org.zeith.hammeranims.core.contents.particles.components.appearance.ParcomCollisionAppearance;
import org.zeith.hammeranims.core.init.ParticleComponentsHA;

public class ParticleEmitter
implements IParticleRotationUpdater {
    public ParticleEffect effect;
    public List<BedrockParticle> particles = new ArrayList<BedrockParticle>();
    public List<BedrockParticle> splitParticles = new ArrayList<BedrockParticle>();
    public final Map<String, InterpolatedDouble.NumberWrapped<ParticleVariables>> variables = new HashMap<String, InterpolatedDouble.NumberWrapped<ParticleVariables>>();
    public final Object2DoubleMap<String> initialValues = new Object2DoubleOpenHashMap();
    public boolean isRenderingGUI = false;
    public IAnimatedObject target;
    public Level world;
    public boolean lit;
    public long lastWorldTick;
    public boolean added;
    public int sanityTicks;
    public boolean running = true;
    private BedrockParticle guiParticle;
    public int generation;
    public ParticleEmitter parent;
    public Vector3d lastGlobal = new Vector3d();
    public Vector3d prevGlobal = new Vector3d();
    public Matrix3f rotation = new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    public Matrix3f prevRotation = new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    public Vector3f angularVelocity = new Vector3f();
    public Vector3d translation = new Vector3d();
    public int age;
    public int lifetime;
    public double spawnedParticles;
    public boolean playing = true;
    public float random1 = (float)Math.random();
    public float random2 = (float)Math.random();
    public float random3 = (float)Math.random();
    public float random4 = (float)Math.random();
    private BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    public double[] scale = new double[]{1.0, 1.0, 1.0};
    public CameraType perspective;
    public float cYaw;
    public float cPitch;
    public double cX;
    public double cY;
    public double cZ;
    public final ParticleVariables vars = new ParticleVariables();
    Long2IntMap brightnessCache = new Long2IntOpenHashMap();

    public void setParent(ParticleEmitter parent) {
        this.parent = parent;
        this.generation = parent != null && parent != this ? parent.generation + 1 : 0;
    }

    public boolean isFinished() {
        return !this.running && this.particles.isEmpty();
    }

    public double getAge() {
        return this.getAge(0.0f);
    }

    public double getAge(float partialTicks) {
        return (double)((float)this.age + partialTicks) / 20.0;
    }

    public void setTarget(IAnimatedObject target) {
        this.target = target;
        this.world = target == null ? null : target.getAnimatedObjectWorld();
    }

    public void setEffect(ParticleEffect scheme) {
        this.setEffect(scheme, null);
    }

    public void setEffect(ParticleEffect effect, Map<String, String> variables) {
        this.effect = effect;
        if (this.effect == null) {
            return;
        }
        for (ParticleCurve curve : effect.curves) {
            this.registerVariable(curve.variable, curve);
        }
        if (variables != null) {
            this.parseVariables(variables);
        }
        this.lit = true;
        this.stop();
        this.start();
        this.setEmitterVariables(0.0f);
    }

    public void setParticleVariables(BedrockParticle particle, float partialTicks) {
        this.vars.particle_age = particle.getAge(partialTicks);
        this.vars.particle_lifetime = (double)particle.lifetime / 20.0;
        this.vars.particle_random_1 = particle.random1;
        this.vars.particle_random_2 = particle.random2;
        this.vars.particle_random_3 = particle.random3;
        this.vars.particle_random_4 = particle.random4;
        Vector3d relativePos = new Vector3d((Vector3dc)particle.getGlobalPosition(this));
        relativePos.sub((Vector3dc)this.lastGlobal);
        this.vars.particle_pos.set(relativePos);
        this.vars.particle_speed.set(particle.speed);
        this.vars.particle_bounces = particle.bounces;
        for (Map.Entry<String, InterpolatedDouble.NumberWrapped<ParticleVariables>> e : this.variables.entrySet()) {
            this.vars.putUpdate(e.getKey(), e.getValue());
        }
    }

    public void setEmitterVariables(float partialTicks) {
        this.vars.emitter_age = this.getAge(partialTicks);
        this.vars.emitter_lifetime = (double)this.lifetime / 20.0;
        this.vars.emitter_random_1 = this.random1;
        this.vars.emitter_random_2 = this.random2;
        this.vars.emitter_random_3 = this.random3;
        this.vars.emitter_random_4 = this.random4;
        for (Map.Entry<String, InterpolatedDouble.NumberWrapped<ParticleVariables>> e : this.variables.entrySet()) {
            this.vars.putUpdate(e.getKey(), e.getValue());
        }
    }

    public void parseVariables(Map<String, String> variables) {
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String name = entry.getKey();
            String expression = entry.getValue();
            this.registerVariable(name, InterpolatedDouble.parse(expression));
        }
    }

    public void registerVariable(String name, InterpolatedDouble<ParticleVariables> expression) {
        if (!name.startsWith("variable.")) {
            HammerAnimations.LOG.warn("Tried to registerVariable, the name '{}' does not start with 'variable.'", (Object)name);
            return;
        }
        this.variables.put(name, new InterpolatedDouble.NumberWrapped<ParticleVariables>(expression));
    }

    public void replaceVariables() {
    }

    public void start() {
        if (this.playing) {
            return;
        }
        this.age = 0;
        this.spawnedParticles = 0.0;
        this.playing = true;
        for (IEmitterInitialize component : this.effect.emitterInitializes) {
            component.apply(this);
        }
    }

    public void stop() {
        if (!this.playing) {
            return;
        }
        this.spawnedParticles = 0.0;
        this.playing = false;
        this.random1 = (float)Math.random();
        this.random2 = (float)Math.random();
        this.random3 = (float)Math.random();
        this.random4 = (float)Math.random();
    }

    public void update() {
        if (this.effect == null) {
            return;
        }
        this.lastWorldTick = this.world.m_46467_();
        this.setEmitterVariables(0.0f);
        for (IEmitterUpdate component : this.effect.emitterUpdates) {
            component.update(this);
        }
        this.setEmitterVariables(0.0f);
        this.updateParticles();
        this.brightnessCache.clear();
        ++this.age;
        ++this.sanityTicks;
        if (this.target != null) {
            this.vars.entity_scale = this.target.getAnimatedObjectScale();
        }
    }

    private void updateParticles() {
        for (int i = 0; i < this.particles.size(); ++i) {
            BedrockParticle particle = this.particles.get(i);
            this.updateParticle(particle);
            if (!particle.dead) continue;
            this.particles.remove(i);
            --i;
            for (IParticleExpiry component : this.effect.particleExpiry) {
                component.expire(this, particle);
            }
        }
        if (!this.splitParticles.isEmpty()) {
            this.particles.addAll(this.splitParticles);
            this.splitParticles.clear();
        }
    }

    private void updateParticle(BedrockParticle particle) {
        particle.update(this);
        this.setParticleVariables(particle, 0.0f);
        for (IParticleUpdate component : this.effect.particleUpdates) {
            component.update(this, particle);
        }
    }

    public void spawnParticle() {
        if (!this.running) {
            return;
        }
        this.particles.add(this.createParticle(false));
    }

    public BedrockParticle createParticle(boolean forceRelative) {
        BedrockParticle particle = new BedrockParticle(this);
        this.setParticleVariables(particle, 0.0f);
        particle.setupMatrix(this);
        for (IParticleInitialize component : this.effect.particleInitializes) {
            component.apply(this, particle);
        }
        Vector3f vec = new Vector3f((float)particle.position.x, (float)particle.position.y, (float)particle.position.z);
        this.rotation.transform(vec);
        particle.position.x = vec.x;
        particle.position.y = vec.y;
        particle.position.z = vec.z;
        if (particle.relativePosition && !particle.relativeRotation) {
            vec = new Vector3d((Vector3dc)particle.position);
            particle.matrix.transform((Vector3d)vec);
            particle.position.x = vec.x;
            particle.position.y = vec.y;
            particle.position.z = vec.z;
        }
        if (!particle.relativePosition || !particle.relativeRotation) {
            particle.position.add((Vector3dc)this.lastGlobal);
            particle.initialPosition.add((Vector3dc)this.lastGlobal);
        }
        particle.prevPosition.set((Vector3dc)particle.position);
        particle.prevRotation = particle.rotation = particle.initialRotation;
        return particle;
    }

    public void renderOnScreen(MultiBufferSource buffers, PoseStack pose, int x, int y, float scale) {
        if (this.effect == null) {
            return;
        }
        float partialTicks = Minecraft.m_91087_().m_91297_();
        List<IParticleRender> listParticle = this.effect.particleRender;
        Matrix3f rotation = this.rotation;
        this.rotation = new Matrix3f();
        if (!listParticle.isEmpty()) {
            VertexConsumer buf = buffers.m_6299_(this.effect.material.renderType.get().apply(this.effect.texture));
            if (this.guiParticle == null || this.guiParticle.dead) {
                this.guiParticle = this.createParticle(true);
            }
            this.rotation.identity();
            this.guiParticle.update(this);
            this.setEmitterVariables(partialTicks);
            this.setParticleVariables(this.guiParticle, partialTicks);
            for (IParticleRender render : listParticle) {
                render.renderOnScreen(this.vars, this.guiParticle, buf, pose, x, y, scale, partialTicks);
            }
        }
        this.rotation = rotation;
    }

    public void render(Camera info, MultiBufferSource buffers, PoseStack pose, float partialTicks) {
        if (this.effect == null) {
            return;
        }
        this.setupCameraProperties(info, partialTicks);
        List<IParticleRender> renders = this.effect.particleRender;
        this.setupOpenGL(partialTicks, pose);
        for (IParticlePreRender iParticlePreRender : this.effect.particlePreRender) {
            iParticlePreRender.preRender(this, partialTicks);
        }
        if (!this.particles.isEmpty()) {
            this.depthSorting();
            Function<ResourceLocation, RenderType> type = this.effect.material.renderType.get();
            VertexConsumer vertexConsumer = buffers.m_6299_(type.apply(this.effect.texture));
            this.renderParticles(vertexConsumer, pose, renders, false, partialTicks);
            ParcomCollisionAppearance collisionAppearance = this.effect.get(ParcomCollisionAppearance.class, ParticleComponentsHA.PARTICLE_COLLISION_APPEARANCE);
            if (collisionAppearance != null && collisionAppearance.texture != null) {
                VertexConsumer vertexConsumer2 = buffers.m_6299_(type.apply(collisionAppearance.texture));
                this.renderParticles(vertexConsumer2, pose, renders, true, partialTicks);
            }
        }
        for (IParticlePostRender iParticlePostRender : this.effect.particlePostRender) {
            iParticlePostRender.postRender(this, partialTicks);
        }
        this.endOpenGL(pose);
    }

    private void renderParticles(VertexConsumer builder, PoseStack pose, List<IParticleRender> renderComponents, boolean collided, float partialTicks) {
        for (BedrockParticle particle : this.particles) {
            boolean collisionStuff;
            boolean bl = collisionStuff = particle.isCollisionTexture(this) || particle.isCollisionTinting(this);
            if (collisionStuff != collided) continue;
            this.setEmitterVariables(partialTicks);
            this.setParticleVariables(particle, partialTicks);
            for (IParticleRender component : renderComponents) {
                if (collisionStuff && component.supportsCollissionRendering()) continue;
                component.render(this.vars, this, particle, builder, pose, partialTicks);
            }
        }
    }

    private void setupOpenGL(float partialTicks, PoseStack pose) {
        if (!this.isRenderingGUI) {
            Entity camera = Minecraft.m_91087_().m_91288_();
            Vec3 playerPos = camera.m_20318_(partialTicks);
            double playerX = playerPos.f_82479_;
            double playerY = playerPos.f_82480_;
            double playerZ = playerPos.f_82481_;
            pose.m_85836_();
            pose.m_85837_(-playerX, -playerY, -playerZ);
            RenderSystem.disableCull();
        }
    }

    private void endOpenGL(PoseStack pose) {
        if (!this.isRenderingGUI) {
            pose.m_85849_();
        }
    }

    private void depthSorting() {
        this.particles.sort((a, b) -> {
            double bd;
            double ad = a.getDistanceSq(this);
            if (ad < (bd = b.getDistanceSq(this))) {
                return 1;
            }
            if (ad > bd) {
                return -1;
            }
            return 0;
        });
    }

    public void setupCameraProperties(Camera info, float partialTicks) {
        if (this.world == null) {
            return;
        }
        Entity camera = Minecraft.m_91087_().m_91288_();
        if (camera == null) {
            return;
        }
        this.perspective = Minecraft.m_91087_().f_91066_.m_92176_();
        this.cYaw = 180.0f - info.m_90590_();
        this.cPitch = 180.0f - info.m_90589_();
        Vec3 cpos = info.m_90583_();
        this.cX = cpos.f_82479_;
        this.cY = cpos.f_82480_ + (double)camera.m_20192_();
        this.cZ = cpos.f_82481_;
    }

    public int getBrightnessForRender(float partialTicks, double x, double y, double z) {
        if (this.lit || this.world == null) {
            return 0xF000F0;
        }
        this.blockPos.m_122169_(x, y, z);
        return this.getBrightnessCached((BlockPos)this.blockPos);
    }

    private int getBrightnessCached(BlockPos pos) {
        return this.brightnessCache.computeIfAbsent(pos.m_121878_(), l -> {
            BlockPos ipos = pos.m_7949_();
            int max = LevelRenderer.m_109541_((BlockAndTintGetter)this.world, (BlockPos)ipos);
            for (Direction dir : Direction.values()) {
                int cur = LevelRenderer.m_109541_((BlockAndTintGetter)this.world, (BlockPos)ipos.m_121945_(dir));
                max = LightTexture.m_109885_((int)Math.max(LightTexture.m_109883_((int)max), LightTexture.m_109883_((int)cur)), (int)Math.max(LightTexture.m_109894_((int)max), LightTexture.m_109894_((int)cur)));
            }
            return max;
        });
    }

    @Override
    public void setMatrix(Matrix3f rotation) {
        this.rotation = rotation;
    }

    @Override
    public boolean emittingParticles() {
        return this.running && this.world.m_46467_() - this.lastWorldTick < 5L;
    }

    public void setWorld(Level world) {
        this.world = world;
    }
}

