/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.particles.emitter;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;
import org.zeith.hammeranims.core.contents.particles.components.appearance.ParcomCollisionAppearance;
import org.zeith.hammeranims.core.contents.particles.components.appearance.ParcomCollisionTinting;
import org.zeith.hammeranims.core.init.ParticleComponentsHA;
import org.zeith.hammeranims.joml.Math;

public class BedrockParticle {
    public final ParticleEmitter owner;
    public float random1 = (float)Math.random();
    public float random2 = (float)Math.random();
    public float random3 = (float)Math.random();
    public float random4 = (float)Math.random();
    public int age;
    public int lifetime;
    public boolean dead;
    public boolean relativePosition;
    public boolean relativeRotation;
    public boolean relativeDirection;
    public boolean relativeScale;
    public boolean relativeScaleBillboard;
    public boolean relativeAcceleration;
    public boolean realisticCollisionDrag;
    public float linearVelocity;
    public float angularVelocity;
    public boolean gravity;
    public boolean manual;
    private int expireAge = -1;
    private int expirationDelay = -1;
    public Vector3f collisionTime = new Vector3f(-2.0f, -2.0f, -2.0f);
    public HashMap<Entity, Vector3f> entityCollisionTime = new HashMap();
    public boolean collided;
    public int bounces;
    public float rotationCollisionDrag = 0.0f;
    public int firstIntersection = -1;
    public boolean intersected;
    public float rotation;
    public float initialRotation;
    public float prevRotation;
    public float rotationVelocity;
    public float rotationAcceleration;
    public float rotationDrag;
    public Vector3d offset = new Vector3d();
    public Vector3d position = new Vector3d();
    public Vector3d initialPosition = new Vector3d();
    public Vector3d prevPosition = new Vector3d();
    public Matrix3d matrix = new Matrix3d();
    private boolean matrixSet;
    public Vector3f speed = new Vector3f();
    public Vector3f acceleration = new Vector3f();
    public Vector3f accelerationFactor = new Vector3f(1.0f, 1.0f, 1.0f);
    public float drag = 0.0f;
    public float dragFactor = 0.0f;
    public float r = 1.0f;
    public float g = 1.0f;
    public float b = 1.0f;
    public float a = 1.0f;
    private Vector3d global = new Vector3d();

    public BedrockParticle(ParticleEmitter owner) {
        this.owner = owner;
        this.speed.set((float)Math.random() - 0.5f, (float)Math.random() - 0.5f, (float)Math.random() - 0.5f);
        this.speed.normalize();
        this.matrix.identity();
    }

    public boolean isCollisionTexture(ParticleEmitter emitter) {
        ParcomCollisionAppearance a = emitter.effect.get(ParcomCollisionAppearance.class, ParticleComponentsHA.PARTICLE_COLLISION_APPEARANCE);
        return a != null && a.enabled.get(this.owner.vars) >= 1.0 && this.intersected;
    }

    public boolean isCollisionTinting(ParticleEmitter emitter) {
        ParcomCollisionTinting a = emitter.effect.get(ParcomCollisionTinting.class, ParticleComponentsHA.PARTICLE_COLLISION_TINTING);
        return a != null && a.enabled.get(this.owner.vars) >= 1.0 && this.intersected;
    }

    public int getExpireAge() {
        return this.expireAge;
    }

    public int getExpirationDelay() {
        return this.expirationDelay;
    }

    public BedrockParticle softCopy(BedrockParticle to) {
        to.age = this.age;
        to.expireAge = this.expireAge;
        to.expirationDelay = this.expirationDelay;
        to.realisticCollisionDrag = this.realisticCollisionDrag;
        to.collisionTime.set((Vector3fc)this.collisionTime);
        to.entityCollisionTime = new HashMap();
        for (Map.Entry<Entity, Vector3f> entry : this.entityCollisionTime.entrySet()) {
            to.entityCollisionTime.put(entry.getKey(), new Vector3f((Vector3fc)entry.getValue()));
        }
        to.bounces = this.bounces;
        to.firstIntersection = this.firstIntersection;
        to.offset.set((Vector3dc)this.offset);
        to.position.set((Vector3dc)this.position);
        to.initialPosition.set((Vector3dc)this.initialPosition);
        to.prevPosition.set((Vector3dc)this.prevPosition);
        to.matrix.set((Matrix3dc)this.matrix);
        to.matrixSet = this.matrixSet;
        to.speed.set((Vector3fc)this.speed);
        to.acceleration.set((Vector3fc)this.acceleration);
        to.accelerationFactor.set((Vector3fc)this.accelerationFactor);
        to.dragFactor = this.dragFactor;
        to.global.set((Vector3dc)this.global);
        return to;
    }

    public double getDistanceSq(ParticleEmitter emitter) {
        Vector3d pos = this.getGlobalPosition(emitter);
        double dx = emitter.cX - pos.x;
        double dy = emitter.cY - pos.y;
        double dz = emitter.cZ - pos.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double getAge(float partialTick) {
        return (double)((float)this.age + partialTick) / 20.0;
    }

    public Vector3d getGlobalPosition(ParticleEmitter emitter) {
        return this.getGlobalPosition(emitter, this.position);
    }

    public Vector3d getGlobalPosition(ParticleEmitter emitter, Vector3d vector) {
        double px = vector.x;
        double py = vector.y;
        double pz = vector.z;
        if (this.relativePosition && this.relativeRotation) {
            Vector3f v = new Vector3f((float)px, (float)py, (float)pz);
            emitter.rotation.transform(v);
            px = v.x;
            py = v.y;
            pz = v.z;
            px += emitter.lastGlobal.x;
            py += emitter.lastGlobal.y;
            pz += emitter.lastGlobal.z;
        }
        this.global.set(px, py, pz);
        return this.global;
    }

    public void update(ParticleEmitter emitter) {
        this.prevRotation = this.rotation;
        this.prevPosition.set((Vector3dc)this.position);
        this.setupMatrix(emitter);
        if (!this.manual) {
            if (this.entityCollisionTime.isEmpty()) {
                this.transformOffsetToGlobal();
            } else {
                for (Map.Entry<Entity, Vector3f> entry : this.entityCollisionTime.entrySet()) {
                    if (entry.getValue().y == (float)this.age) continue;
                    this.transformOffsetToGlobal();
                }
            }
            float rotationDrag = (this.rotationDrag + this.rotationCollisionDrag) * this.rotationVelocity;
            float rotationAcceleration = this.rotationAcceleration / 20.0f;
            this.rotationVelocity = Math.clamp(Math.min(this.rotationVelocity, 0.0f), Math.max(this.rotationVelocity, 0.0f), this.rotationVelocity - rotationDrag / 20.0f);
            this.rotationVelocity += rotationAcceleration / 20.0f;
            this.rotation += this.rotationVelocity;
            if (this.age == 0) {
                if (this.relativeDirection) {
                    emitter.rotation.transform(this.speed);
                }
                if (this.linearVelocity != 0.0f) {
                    Vector3d v = new Vector3d((Vector3dc)emitter.lastGlobal);
                    v.x -= emitter.prevGlobal.x;
                    v.y -= emitter.prevGlobal.y;
                    v.z -= emitter.prevGlobal.z;
                    this.speed.x += (float)(v.x * (double)this.linearVelocity);
                    this.speed.y += (float)(v.y * (double)this.linearVelocity);
                    this.speed.z += (float)(v.z * (double)this.linearVelocity);
                }
                if (this.angularVelocity != 0.0f) {
                    Matrix3f rotation1 = new Matrix3f((Matrix3fc)emitter.rotation);
                    Matrix3f identity = new Matrix3f();
                    identity.identity();
                    Matrix3f rotation0 = new Matrix3f((Matrix3fc)emitter.prevRotation);
                    rotation0.invert();
                    rotation1.mul((Matrix3fc)rotation0);
                    Vector3d angularV = BedrockParticle.getAngularVelocity(rotation1);
                    Vector3d radius = new Vector3d((Vector3dc)emitter.translation);
                    radius.x += this.position.x - emitter.lastGlobal.x;
                    radius.y += this.position.y - emitter.lastGlobal.y;
                    radius.z += this.position.z - emitter.lastGlobal.z;
                    Vector3d v = new Vector3d();
                    angularV.cross((Vector3dc)radius, v);
                    this.speed.x += (float)(v.x * (double)this.angularVelocity);
                    this.speed.y += (float)(v.y * (double)this.angularVelocity);
                    this.speed.z += (float)(v.z * (double)this.angularVelocity);
                }
            }
            if (this.relativeAcceleration) {
                emitter.rotation.transform(this.acceleration);
            }
            if (this.gravity) {
                this.acceleration.y = (float)((double)this.acceleration.y - 9.81);
            }
            Vector3f drag = new Vector3f((Vector3fc)this.speed);
            drag.mul(-(this.drag + this.dragFactor));
            drag.mul(0.05f);
            if (this.speed.length() - drag.length() <= 0.0f) {
                this.speed.mul(0.0f);
            } else {
                this.speed.add((Vector3fc)drag);
            }
            this.acceleration.mul(0.05f);
            this.speed.add((Vector3fc)this.acceleration);
            Vector3f speed0 = new Vector3f((Vector3fc)this.speed);
            speed0.x *= this.accelerationFactor.x;
            speed0.y *= this.accelerationFactor.y;
            speed0.z *= this.accelerationFactor.z;
            if (this.relativePosition || this.relativeRotation) {
                this.matrix.transform(speed0);
            }
            this.position.x += (double)(speed0.x / 20.0f);
            this.position.y += (double)(speed0.y / 20.0f);
            this.position.z += (double)(speed0.z / 20.0f);
        }
        ++this.age;
        this.acceleration.set(0.0f, 0.0f, 0.0f);
        if (this.lifetime >= 0 && (this.age >= this.lifetime || this.age >= this.expireAge && this.expireAge != -1)) {
            this.dead = true;
        }
    }

    public void setExpirationDelay(double delay) {
        int expirationDelay = (int)delay;
        if (this.age + expirationDelay < this.expireAge || this.expireAge == -1) {
            this.expirationDelay = Math.abs(expirationDelay);
            this.expireAge = this.age + this.expirationDelay;
        }
    }

    public void setupMatrix(ParticleEmitter emitter) {
        if (this.relativePosition) {
            if (this.relativeRotation) {
                this.matrix.identity();
            } else if (!this.matrixSet) {
                this.matrix.set((Matrix3fc)emitter.rotation);
                this.matrixSet = true;
            }
        } else if (this.relativeRotation) {
            this.matrix.set((Matrix3fc)emitter.rotation);
        }
    }

    public void transformOffsetToGlobal() {
        this.offset.mul(6.0);
        this.speed.x = (float)((double)this.speed.x + this.offset.x);
        this.speed.y = (float)((double)this.speed.y + this.offset.y);
        this.speed.z = (float)((double)this.speed.z + this.offset.z);
        this.offset.mul(0.0);
    }

    public static Vector3d getAngularVelocity(Matrix3f rotation) {
        Matrix3f step = new Matrix3f((Matrix3fc)rotation);
        Matrix3f angularVelocity = new Matrix3f();
        Matrix3f i = new Matrix3f();
        i.identity();
        angularVelocity.identity();
        angularVelocity.scale(2.0f);
        step.add((Matrix3fc)i);
        step.invert();
        step.scale(4.0f);
        angularVelocity.sub((Matrix3fc)step);
        return new Vector3d((double)angularVelocity.m21, (double)(-angularVelocity.m20), (double)angularVelocity.m10);
    }
}

