/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.particles.components;

import com.google.gson.JsonElement;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.particles.components.IComponentDeserializer;
import org.zeith.hammeranims.api.particles.components.IParticleComponent;

public interface IParticleComponentType {
    public static final Map<ResourceLocation, ResourceLocation> VANILLA_COMPONENTS = Stream.of("emitter_local_space", "emitter_initialization", "emitter_rate_instant", "emitter_rate_steady", "emitter_lifetime_looping", "emitter_lifetime_once", "emitter_lifetime_expression", "emitter_shape_disc", "emitter_shape_box", "emitter_shape_entity_aabb", "emitter_shape_point", "emitter_shape_sphere", "particle_lifetime_expression", "particle_expire_if_in_blocks", "particle_expire_if_not_in_blocks", "particle_kill_plane", "particle_appearance_billboard", "particle_appearance_lighting", "particle_appearance_tinting", "particle_initial_speed", "particle_initial_spin", "particle_motion_collision", "particle_motion_dynamic", "particle_motion_parametric").collect(Collectors.toMap(ResourceLocation::new, HammerAnimations::id));

    public IParticleComponent fromJson(JsonElement var1);

    public boolean canBeEmpty();

    default public ResourceLocation getRegistryKey() {
        return HammerAnimationsApi.particleComponentTypes().getKey((Object)this);
    }

    public static IParticleComponentType byId(ResourceLocation id) {
        return (IParticleComponentType)HammerAnimationsApi.particleComponentTypes().getValue(VANILLA_COMPONENTS.getOrDefault(id, id));
    }

    public static SimpleBuilder builder() {
        return new SimpleBuilder();
    }

    public static IParticleComponentType create(IComponentDeserializer deserializer) {
        return IParticleComponentType.builder().deserializer(deserializer).build();
    }

    public static class SimpleBuilder {
        protected boolean canBeEmpty = false;
        protected IComponentDeserializer deserializer;

        public SimpleBuilder canBeEmpty(boolean canBeEmpty) {
            this.canBeEmpty = canBeEmpty;
            return this;
        }

        public SimpleBuilder deserializer(IComponentDeserializer deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public SimpleType build() {
            return new SimpleType(this.canBeEmpty, this.deserializer);
        }
    }

    public static class SimpleType
    implements IParticleComponentType {
        protected final boolean canBeEmpty;
        protected final IComponentDeserializer deserializer;

        public SimpleType(boolean canBeEmpty, IComponentDeserializer deserializer) {
            this.canBeEmpty = canBeEmpty;
            this.deserializer = deserializer;
        }

        @Override
        public IParticleComponent fromJson(JsonElement element) {
            return this.deserializer.fromJson(element);
        }

        @Override
        public boolean canBeEmpty() {
            return this.canBeEmpty;
        }
    }
}

