/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.particles;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.core.client.particle.ParticleRenderTypes;

public enum ParticleMaterial {
    OPAQUE("particles_opaque", () -> ParticleRenderTypes::particleSolid),
    ALPHA("particles_alpha", () -> ParticleRenderTypes::particleCutout),
    BLEND("particles_blend", () -> ParticleRenderTypes::particleTranslucent),
    ADDITIVE("particles_add", () -> ParticleRenderTypes::particleAdditive);

    public final String id;
    public final Supplier<Function<ResourceLocation, RenderType>> renderType;

    public static ParticleMaterial fromString(String material) {
        for (ParticleMaterial mat : ParticleMaterial.values()) {
            if (!mat.id.equals(material)) continue;
            return mat;
        }
        return OPAQUE;
    }

    private ParticleMaterial(String id, Supplier<Function<ResourceLocation, RenderType>> renderType) {
        this.id = id;
        this.renderType = renderType;
    }
}

