/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.particles;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.api.particles.ParticleMaterial;
import org.zeith.hammeranims.api.particles.components.IParticleComponent;
import org.zeith.hammeranims.api.particles.components.IParticleComponentType;
import org.zeith.hammeranims.api.particles.components.itf.IEmitterInitialize;
import org.zeith.hammeranims.api.particles.components.itf.IEmitterUpdate;
import org.zeith.hammeranims.api.particles.components.itf.IParticleExpiry;
import org.zeith.hammeranims.api.particles.components.itf.IParticleInitialize;
import org.zeith.hammeranims.api.particles.components.itf.IParticlePostRender;
import org.zeith.hammeranims.api.particles.components.itf.IParticlePreRender;
import org.zeith.hammeranims.api.particles.components.itf.IParticleRender;
import org.zeith.hammeranims.api.particles.components.itf.IParticleUpdate;
import org.zeith.hammeranims.api.particles.curve.ParticleCurve;
import org.zeith.hammeranims.api.particles.event.CreateParticleEffectEvent;
import org.zeith.hammeranims.api.utils.InstanceGatherer;
import org.zeith.hammeranims.core.init.ParticleComponentsHA;
import org.zeith.hammerlib.util.java.Cast;

public class ParticleEffect {
    public final IParticleContainer container;
    public final ParticleMaterial material;
    public final ResourceLocation texture;
    public final List<ParticleCurve> curves;
    public final Map<IParticleComponentType, IParticleComponent> components;
    public final List<IEmitterInitialize> emitterInitializes;
    public final List<IEmitterUpdate> emitterUpdates;
    public final List<IParticleInitialize> particleInitializes;
    public final List<IParticleUpdate> particleUpdates;
    public final List<IParticleRender> particleRender;
    public final List<IParticlePreRender> particlePreRender;
    public final List<IParticlePostRender> particlePostRender;
    public final List<IParticleExpiry> particleExpiry;

    public ParticleEffect(IParticleContainer container, ParticleMaterial material, ResourceLocation texture, List<ParticleCurve> curves, ImmutableMap.Builder<IParticleComponentType, IParticleComponent> components) {
        this.container = container;
        this.material = material;
        this.texture = texture;
        this.curves = curves;
        this.components = components.build();
        Collection<IParticleComponent> coms = this.components.values();
        this.emitterInitializes = InstanceGatherer.getComponents(coms, IEmitterInitialize.class);
        this.emitterUpdates = InstanceGatherer.getComponents(coms, IEmitterUpdate.class);
        this.particleInitializes = InstanceGatherer.getComponents(coms, IParticleInitialize.class);
        this.particleUpdates = InstanceGatherer.getComponents(coms, IParticleUpdate.class);
        this.particleRender = InstanceGatherer.getComponents(coms, IParticleRender.class);
        this.particlePreRender = InstanceGatherer.getComponents(coms, IParticlePreRender.class);
        this.particlePostRender = InstanceGatherer.getComponents(coms, IParticlePostRender.class);
        this.particleExpiry = InstanceGatherer.getComponents(coms, IParticleExpiry.class);
    }

    public static ParticleEffect empty(IParticleContainer container) {
        return ParticleEffect.builder().build(container);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T extends IParticleComponent> T get(Class<T> base, IParticleComponentType type) {
        return (T)((IParticleComponent)Cast.cast((Object)this.components.get(type), base));
    }

    public static class Builder {
        protected final Map<IParticleComponentType, IParticleComponent> components = new HashMap<IParticleComponentType, IParticleComponent>();
        protected final List<ParticleCurve> curves = new ArrayList<ParticleCurve>();
        protected ParticleMaterial material = ParticleMaterial.OPAQUE;
        protected ResourceLocation texture = InventoryMenu.f_39692_;

        public Builder material(ParticleMaterial material) {
            this.material = material;
            return this;
        }

        public Builder texture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public Builder curve(ParticleCurve curve) {
            this.curves.add(curve);
            return this;
        }

        public Builder component(IParticleComponentType type, IParticleComponent component) {
            this.components.put(type, component);
            return this;
        }

        public ParticleEffect build(IParticleContainer container) {
            if (!this.components.containsKey(ParticleComponentsHA.PARTICLE_INITIAL_SPEED)) {
                this.component(ParticleComponentsHA.PARTICLE_INITIAL_SPEED, ParticleComponentsHA.PARTICLE_INITIAL_SPEED.fromJson((JsonElement)JsonNull.INSTANCE));
            }
            HammerAnimationsApi.EVENT_BUS.post((Event)new CreateParticleEffectEvent(container, this.components, this));
            ImmutableMap.Builder components = ImmutableMap.builder().putAll(this.components);
            return new ParticleEffect(container, this.material, this.texture, Collections.unmodifiableList(this.curves), (ImmutableMap.Builder<IParticleComponentType, IParticleComponent>)components);
        }
    }
}

