/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.geometry.model;

import net.minecraft.world.phys.Vec3;
import org.zeith.hammeranims.api.geometry.constrains.IBoneConstraints;

public class GeometryTransforms {
    public static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);
    public Vec3 translation;
    public Vec3 rotation;
    public Vec3 scale;

    public GeometryTransforms(Vec3 translation, Vec3 rotation, Vec3 scale) {
        this.translation = translation;
        this.rotation = rotation;
        this.scale = scale;
    }

    public static GeometryTransforms createDefault() {
        return new GeometryTransforms(Vec3.f_82478_, Vec3.f_82478_, ONE);
    }

    public void applyConstraints(IBoneConstraints constraints) {
        double z;
        double y;
        double x;
        if (constraints.hasTranslation()) {
            x = Math.max(constraints.getMinTranslationX(), Math.min(constraints.getMaxTranslationX(), this.translation.f_82479_));
            y = Math.max(constraints.getMinTranslationY(), Math.min(constraints.getMaxTranslationY(), this.translation.f_82480_));
            z = Math.max(constraints.getMinTranslationZ(), Math.min(constraints.getMaxTranslationZ(), this.translation.f_82481_));
            this.translation = new Vec3(x, y, z);
        }
        if (constraints.hasRotation()) {
            x = Math.max(constraints.getMinRotationX(), Math.min(constraints.getMaxRotationX(), this.rotation.f_82479_));
            y = Math.max(constraints.getMinRotationY(), Math.min(constraints.getMaxRotationY(), this.rotation.f_82480_));
            z = Math.max(constraints.getMinRotationZ(), Math.min(constraints.getMaxRotationZ(), this.rotation.f_82481_));
            this.rotation = new Vec3(x, y, z);
        }
        if (constraints.hasScale()) {
            x = Math.max(constraints.getMinScaleX(), Math.min(constraints.getMaxScaleX(), this.scale.f_82479_));
            y = Math.max(constraints.getMinScaleY(), Math.min(constraints.getMaxScaleY(), this.scale.f_82480_));
            z = Math.max(constraints.getMinScaleZ(), Math.min(constraints.getMaxScaleZ(), this.scale.f_82481_));
            this.scale = new Vec3(x, y, z);
        }
    }

    public GeometryTransforms copy() {
        return new GeometryTransforms(this.translation, this.rotation, this.scale);
    }
}

