/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.geometry.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.zeith.hammeranims.api.animation.data.BoneAnimation;
import org.zeith.hammeranims.api.animation.data.IAnimationData;
import org.zeith.hammeranims.api.animation.interp.BlendMode;
import org.zeith.hammeranims.api.animation.interp.Query;
import org.zeith.hammeranims.api.animsys.SerializableMask;
import org.zeith.hammeranims.api.animsys.layer.ILayerMask;
import org.zeith.hammeranims.api.geometry.model.GeometryTransforms;

public class GeometryPose {
    protected final Map<String, GeometryTransforms> boneTransforms = new HashMap<String, GeometryTransforms>();
    protected final Map<String, GeometryTransforms> boneTransformsView = Collections.unmodifiableMap(this.boneTransforms);
    protected final Predicate<String> availableBones;

    public GeometryPose() {
        this(b -> true);
    }

    public GeometryPose(Predicate<String> availableBones) {
        this.availableBones = availableBones;
    }

    public void reset() {
        this.boneTransforms.clear();
    }

    public void apply(IAnimationData animation, ILayerMask mask, BlendMode mode, float weight, Query query) {
        for (Map.Entry<String, BoneAnimation> entry : animation.getBoneAnimations().entrySet()) {
            String bone = entry.getKey();
            if (!this.availableBones.test(bone) || !mask.test(bone)) continue;
            this.boneTransforms.put(bone, entry.getValue().apply(query, mode, weight, this.boneTransforms.get(bone)));
        }
    }

    public void apply(SerializableMask animationMask, IAnimationData animation, ILayerMask mask, BlendMode mode, float weight, Query query) {
        Set<String> excludes = animationMask.getExcludes();
        SerializableMask.WeightFunction weightFun = animationMask.getBoneWeight();
        for (Map.Entry<String, BoneAnimation> entry : animation.getBoneAnimations().entrySet()) {
            String bone = entry.getKey();
            if (!this.availableBones.test(bone) || !mask.test(bone) || excludes.contains(bone)) continue;
            this.boneTransforms.put(bone, entry.getValue().apply(query, mode, weight * weightFun.get(bone), this.boneTransforms.get(bone)));
        }
    }

    public GeometryPose copy() {
        GeometryPose c = new GeometryPose(this.availableBones);
        for (Map.Entry<String, GeometryTransforms> bone : this.boneTransforms.entrySet()) {
            c.boneTransforms.put(bone.getKey(), bone.getValue().copy());
        }
        return c;
    }

    public GeometryTransforms getTransform(String bone) {
        if (!this.availableBones.test(bone)) {
            return null;
        }
        return this.boneTransforms.computeIfAbsent(bone, key -> GeometryTransforms.createDefault());
    }

    public Map<String, GeometryTransforms> getBoneTransforms() {
        return this.boneTransformsView;
    }
}

