/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.event;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammeranims.api.utils.IResourceProvider;

public abstract class ReloadHammerAnimationsEvent
extends Event {
    private final IResourceProvider resources;
    private final boolean clientSide;

    protected ReloadHammerAnimationsEvent(IResourceProvider provider, boolean clientSide) {
        this.resources = provider;
        this.clientSide = clientSide;
    }

    public IResourceProvider getResources() {
        return this.resources;
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public static class Post
    extends ReloadHammerAnimationsEvent {
        public Post(IResourceProvider provider, boolean clientSide) {
            super(provider, clientSide);
        }
    }

    public static class EnqueueReloads
    extends ReloadHammerAnimationsEvent {
        protected final Consumer<CompletableFuture<?>> extraReload;
        protected final Executor gameExecutor;
        protected final Executor backgroundExecutor;

        public EnqueueReloads(IResourceProvider provider, boolean clientSide, Consumer<CompletableFuture<?>> extraReload, Executor gameExecutor, Executor backgroundExecutor) {
            super(provider, clientSide);
            this.extraReload = extraReload;
            this.gameExecutor = gameExecutor;
            this.backgroundExecutor = backgroundExecutor;
        }

        public void addReload(CompletableFuture<?> ... cfs) {
            this.addReloadTask(CompletableFuture.allOf(cfs));
        }

        public void addReloadTask(CompletableFuture<?> task) {
            this.extraReload.accept(task);
        }

        public <T> void enqueue(Stream<T> task, BiFunction<T, Executor, CompletableFuture<?>> factory) {
            this.addReload((CompletableFuture[])task.map(t -> (CompletableFuture)factory.apply(t, this.getBackgroundExecutor())).toArray(CompletableFuture[]::new));
        }

        public Executor getGameExecutor() {
            return this.gameExecutor;
        }

        public Executor getBackgroundExecutor() {
            return this.backgroundExecutor;
        }
    }
}

