/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys.layer;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@FunctionalInterface
public interface ILayerMask
extends Predicate<String> {
    public static final ILayerMask TRUE = bone -> true;
    public static final ILayerMask FALSE = bone -> false;

    @Override
    public boolean test(String var1);

    default public ILayerMask negate() {
        ILayerMask th = this;
        return bone -> !th.test(bone);
    }

    default public ILayerMask not() {
        ILayerMask th = this;
        return bone -> !th.test(bone);
    }

    default public ILayerMask or(Predicate<? super String> other) {
        ILayerMask th = this;
        return bone -> th.test(bone) || other.test(bone);
    }

    default public ILayerMask nor(Predicate<? super String> other) {
        ILayerMask th = this;
        return bone -> !th.test(bone) && !other.test(bone);
    }

    default public ILayerMask and(Predicate<? super String> other) {
        ILayerMask th = this;
        return bone -> th.test(bone) && other.test(bone);
    }

    default public ILayerMask nand(Predicate<? super String> other) {
        ILayerMask th = this;
        return bone -> !th.test(bone) || !other.test(bone);
    }

    public static ILayerMask anyOf(String ... bones) {
        List<String> boneList = Arrays.asList(bones);
        return boneList::contains;
    }

    public static ILayerMask noneOf(String ... bones) {
        return ILayerMask.anyOf(bones).negate();
    }
}

