/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys.layer;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.zeith.hammeranims.api.animation.Animation;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.IAnimationSource;
import org.zeith.hammeranims.api.animation.data.IAnimationData;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedParticleEffect;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedSoundEffect;
import org.zeith.hammeranims.api.animation.interp.BlendMode;
import org.zeith.hammeranims.api.animation.interp.Query;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.ConfiguredAnimation;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammeranims.api.animsys.SerializableMask;
import org.zeith.hammeranims.api.animsys.actions.AnimationActionInstance;
import org.zeith.hammeranims.api.animsys.layer.ActiveAnimation;
import org.zeith.hammeranims.api.animsys.layer.ILayerMask;
import org.zeith.hammeranims.api.geometry.model.GeometryPose;
import org.zeith.hammeranims.api.particles.emitter.IParticleRotationUpdater;
import org.zeith.hammeranims.api.utils.ICompoundSerializable;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammeranims.core.utils.InstanceHelpers;

public class AnimationLayer
implements ICompoundSerializable {
    public final AnimationSystem system;
    public final boolean allowAutoSync;
    public final boolean persistent;
    public final ILayerMask mask;
    public final Query query;
    public final String name;
    public final BlendMode mode;
    public ActiveAnimation lastAnimation;
    public double startTime;
    public ActiveAnimation currentAnimation;
    private final Map<IParticleRotationUpdater, AnimatedParticleEffect> particles = new HashMap<IParticleRotationUpdater, AnimatedParticleEffect>();
    public float weight = 1.0f;
    public boolean frozen;

    public AnimationLayer(AnimationSystem sys, ILayerMask mask, Query query, String name, BlendMode mode, boolean allowAutoSync, boolean persistent) {
        this.system = sys;
        this.mask = mask;
        this.query = query;
        this.name = name;
        this.mode = mode;
        this.allowAutoSync = allowAutoSync;
        this.persistent = persistent;
    }

    @Nullable
    public ActiveAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public AnimationLocation activeAnimationLocation() {
        return this.currentAnimation != null ? this.currentAnimation.getLocation() : DefaultsHA.NULL_ANIM.get().getLocation();
    }

    public Animation activeAnimation() {
        return this.currentAnimation != null ? this.currentAnimation.config.animation : DefaultsHA.NULL_ANIM.get();
    }

    public boolean startAnimation(@Nonnull IAnimationSource animation) {
        return this.startAnimation(animation.configure());
    }

    public boolean startAnimation(@Nonnull ConfiguredAnimation animation) {
        ConfiguredAnimation cur;
        if (!animation.important && (this.currentAnimation != null ? (cur = this.currentAnimation.config).same(animation) : Objects.equals(animation.getLocation(), this.currentAnimation != null ? this.currentAnimation.getLocation() : null))) {
            return false;
        }
        this.lastAnimation = this.currentAnimation;
        this.startTime = this.system.getTime(0.0f);
        this.currentAnimation = animation.activate(this);
        if (this.system.autoSync && this.allowAutoSync) {
            this.system.sync();
        }
        return true;
    }

    public void applyAnimation(double sysTime, float partialTicks, GeometryPose pose) {
        SerializableMask sm;
        float weight;
        float transitionTime;
        if (this.frozen) {
            sysTime -= (double)partialTicks * 0.05;
            partialTicks = 0.0f;
        }
        if (this.lastAnimation != null) {
            transitionTime = this.currentAnimation != null ? this.currentAnimation.config.transitionTime : 0.25f;
            weight = (transitionTime <= 0.0f ? 0.0f : (float)(1.0 - Math.min(sysTime - this.startTime, (double)transitionTime) / (double)transitionTime)) * this.weight * this.lastAnimation.getWeight();
            this.query.setTime(this.system, sysTime, partialTicks, this.lastAnimation);
            sm = this.lastAnimation.config.mask;
            if (sm != null) {
                pose.apply(sm, this.lastAnimation.config.getAnimation().getData(), this.mask, this.mode, weight, this.query);
            } else {
                pose.apply(this.lastAnimation.config.getAnimation().getData(), this.mask, this.mode, weight, this.query);
            }
        }
        if (this.currentAnimation != null) {
            transitionTime = this.currentAnimation.config.transitionTime;
            weight = (transitionTime <= 0.0f ? 1.0f : (float)Math.min(sysTime - this.startTime, (double)transitionTime) / transitionTime) * this.weight * this.currentAnimation.getWeight();
            this.query.setTime(this.system, sysTime, partialTicks, this.currentAnimation);
            sm = this.currentAnimation.config.mask;
            if (sm != null) {
                pose.apply(sm, this.currentAnimation.config.getAnimation().getData(), this.mask, this.mode, weight, this.query);
            } else {
                pose.apply(this.currentAnimation.config.getAnimation().getData(), this.mask, this.mode, weight, this.query);
            }
        }
    }

    public void processEffects(double sysTime, @NotNull ActiveAnimation a) {
        int ticks = (int)Math.round(a.config.timeFunction.getTime(this.system, sysTime, 0.0f, a) * 20.0);
        if (a.lastTick != ticks) {
            int prev = a.lastTick;
            a.lastTick = ticks;
            Animation anim = a.config.getAnimation();
            if (anim == null) {
                return;
            }
            IAnimationData data = anim.getData();
            Int2ObjectMap<List<AnimatedParticleEffect>> particles = data.getParticleEffects();
            Int2ObjectMap<List<AnimatedSoundEffect>> sounds = data.getSoundEffects();
            IAnimatedObject owner = this.system.owner;
            for (int i = prev; i < ticks; ++i) {
                List fx;
                List snds = (List)sounds.get(i);
                if (snds != null) {
                    snds.forEach(owner::playSound);
                }
                if ((fx = (List)particles.get(i)) == null) continue;
                for (AnimatedParticleEffect effect : fx) {
                    IParticleRotationUpdater pp = owner.playParticle(effect);
                    if (pp == null) continue;
                    this.particles.put(pp, effect);
                }
            }
        }
    }

    public void tick(double sysTime) {
        this.particles.entrySet().removeIf(upd -> {
            IParticleRotationUpdater u = (IParticleRotationUpdater)upd.getKey();
            Matrix3f mat = this.system.owner.getParticleEffectRotation((AnimatedParticleEffect)upd.getValue());
            if (mat != null) {
                u.setMatrix(mat);
            }
            return !u.emittingParticles();
        });
        if (this.frozen) {
            this.startTime += 0.05;
            if (this.currentAnimation != null) {
                this.currentAnimation.activationTime += 0.05;
            }
            if (this.lastAnimation != null) {
                this.lastAnimation.activationTime += 0.05;
            }
        } else {
            if (this.currentAnimation != null) {
                this.processEffects(sysTime, this.currentAnimation);
            }
            if (this.lastAnimation != null) {
                this.processEffects(sysTime, this.lastAnimation);
            }
        }
        if (this.lastAnimation != null) {
            float weight;
            float transitionTime = this.currentAnimation != null ? this.currentAnimation.config.transitionTime : 0.25f;
            float f = weight = transitionTime <= 0.0f ? 0.0f : (float)(1.0 - Math.min(sysTime - this.startTime, (double)transitionTime) / (double)transitionTime) * this.weight * this.lastAnimation.config.weight;
            if (weight <= 0.0f) {
                this.lastAnimation = null;
            }
        }
        if (this.currentAnimation != null && this.currentAnimation.isDone(sysTime)) {
            if (!this.currentAnimation.firedActions) {
                this.currentAnimation.firedActions = true;
                for (AnimationActionInstance action : this.currentAnimation.config.onFinish) {
                    action.execute(this);
                }
            }
            if (this.currentAnimation.config.next != null) {
                this.startAnimation(this.currentAnimation.config.next);
            }
        }
    }

    public boolean stopAnimation() {
        return this.startAnimation(ConfiguredAnimation.noAnimation());
    }

    public boolean stopAnimation(float transitionTime) {
        return this.startAnimation(ConfiguredAnimation.noAnimation().transitionTime(transitionTime));
    }

    public boolean stopAnimation(Duration transitionTime) {
        return this.startAnimation(ConfiguredAnimation.noAnimation().transitionTime(transitionTime));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = InstanceHelpers.newNBTCompound();
        tag.m_128350_("Weight", this.weight);
        tag.m_128359_("Name", this.name);
        tag.m_128347_("StartTime", this.startTime);
        tag.m_128379_("Frozen", this.frozen);
        if (this.lastAnimation != null) {
            tag.m_128365_("Last", (Tag)this.lastAnimation.serializeNBT());
        }
        if (this.currentAnimation != null) {
            tag.m_128365_("Current", (Tag)this.currentAnimation.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.weight = tag.m_128457_("Weight");
        this.startTime = tag.m_128459_("StartTime");
        this.frozen = tag.m_128471_("Frozen");
        this.lastAnimation = tag.m_128425_("Last", 10) ? new ActiveAnimation(tag.m_128469_("Last")) : null;
        this.currentAnimation = tag.m_128425_("Current", 10) ? new ActiveAnimation(tag.m_128469_("Current")) : null;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public void freeze(boolean b) {
        if (this.frozen != b) {
            this.frozen = b;
            this.system.sync();
        }
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public static class Builder {
        protected final String name;
        protected float weight = 1.0f;
        protected boolean allowAutoSync = true;
        protected boolean persistent = true;
        protected Query query = new Query();
        protected ILayerMask mask = ILayerMask.TRUE;
        protected BlendMode blendMode = BlendMode.ADD;

        public Builder(String name) {
            this.name = name;
        }

        public Builder query(Query query) {
            this.query = query;
            return this;
        }

        public Builder mask(ILayerMask mask) {
            this.mask = mask;
            return this;
        }

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        public Builder blendMode(BlendMode blendMode) {
            this.blendMode = blendMode;
            return this;
        }

        public Builder allowAutoSync(boolean allowAutoSync) {
            this.allowAutoSync = allowAutoSync;
            return this;
        }

        public Builder preventAutoSync() {
            this.allowAutoSync = false;
            return this;
        }

        public Builder persistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder nonPersistent() {
            this.persistent = false;
            return this;
        }

        public AnimationLayer build(AnimationSystem sys) {
            AnimationLayer layer = new AnimationLayer(sys, this.mask, this.query, this.name, this.blendMode, this.allowAutoSync, this.persistent);
            layer.weight = this.weight;
            return layer;
        }
    }
}

