/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys.layer;

import net.minecraft.nbt.CompoundTag;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.LoopMode;
import org.zeith.hammeranims.api.animation.data.IAnimationData;
import org.zeith.hammeranims.api.animsys.ConfiguredAnimation;
import org.zeith.hammeranims.api.utils.ICompoundSerializable;
import org.zeith.hammeranims.core.init.DefaultsHA;

public class ActiveAnimation
implements ICompoundSerializable {
    public double activationTime;
    public ConfiguredAnimation config;
    public boolean firedActions;
    public float realTimeWeight = 1.0f;
    public int lastTick;

    public ActiveAnimation(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public ActiveAnimation(ConfiguredAnimation config) {
        this.config = config;
    }

    public boolean isDone(double sysTime) {
        IAnimationData data;
        return this.config.animation == null || this.config.loopMode == LoopMode.ONCE && ((data = this.config.animation.getData()) == null || (sysTime - this.activationTime) * (double)this.config.speed >= this.getLengthSeconds());
    }

    public AnimationLocation getLocation() {
        return this.config.animation != null ? this.config.animation.getLocation() : DefaultsHA.NULL_ANIM.get().getLocation();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = this.config.serializeNBT();
        tag.m_128347_("ActivationTime", this.activationTime);
        tag.m_128379_("FiredActions", this.firedActions);
        tag.m_128350_("ActiveWeight", this.realTimeWeight);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.config = new ConfiguredAnimation(tag);
        this.activationTime = tag.m_128459_("ActivationTime");
        this.firedActions = tag.m_128471_("FiredActions");
        this.realTimeWeight = tag.m_128425_("ActiveWeight", 99) ? tag.m_128457_("ActiveWeight") : 1.0f;
    }

    public float getWeight() {
        return this.realTimeWeight * this.config.weight * this.config.getAnimation().getData().getWeight();
    }

    public double getLengthSeconds() {
        return this.config.timeFunction.getLengthSeconds(this);
    }
}

