/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys.actions;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.animsys.actions.AnimationAction;
import org.zeith.hammeranims.api.animsys.layer.AnimationLayer;
import org.zeith.hammeranims.api.utils.ICompoundSerializable;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammeranims.core.utils.InstanceHelpers;

public class AnimationActionInstance
implements ICompoundSerializable {
    public static final AnimationActionInstance EMPTY = new AnimationActionInstance(DefaultsHA.EMPTY_ACTION);
    private CompoundTag extra;
    public final AnimationAction action;

    public AnimationActionInstance(AnimationAction action) {
        this.action = action;
    }

    public void execute(AnimationLayer layer) {
        this.action.execute(this, layer);
    }

    public final boolean isEmpty() {
        return this.action == DefaultsHA.EMPTY_ACTION;
    }

    @Nonnull
    public static AnimationActionInstance of(CompoundTag tag) {
        AnimationAction action = (AnimationAction)HammerAnimationsApi.animationActions().getValue(new ResourceLocation(tag.m_128461_("Id")));
        return action == null || action == DefaultsHA.EMPTY_ACTION ? EMPTY : action.deserializeInstance(tag);
    }

    public CompoundTag getExtra() {
        CompoundTag i = InstanceHelpers.newNBTCompound();
        if (this.extra == null && !this.isEmpty()) {
            this.extra = i;
        }
        return i;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = InstanceHelpers.newNBTCompound();
        if (this.extra != null) {
            tag.m_128365_("Extra", (Tag)this.extra);
        }
        tag.m_128359_("Id", this.action.getRegistryKey().toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("Extra", 10)) {
            this.extra = nbt.m_128469_("Extra");
        }
    }
}

