/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.zeith.hammeranims.api.utils.ICompoundSerializable;
import org.zeith.hammeranims.core.utils.InstanceHelpers;

public class SerializableMask
implements ICompoundSerializable {
    protected Set<String> excludes = new HashSet<String>();
    protected Object2FloatMap<String> boneWeights = null;

    public SerializableMask(CompoundTag mask) {
        this.deserializeNBT(mask);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = InstanceHelpers.newNBTCompound();
        ListTag excludeNBT = InstanceHelpers.newNBTList();
        for (String exclude : this.excludes) {
            excludeNBT.add((Object)InstanceHelpers.newNBTString(exclude));
        }
        nbt.m_128365_("Excludes", (Tag)excludeNBT);
        if (this.boneWeights != null && !this.boneWeights.isEmpty()) {
            CompoundTag weightNBT = InstanceHelpers.newNBTCompound();
            for (Object2FloatMap.Entry e : this.boneWeights.object2FloatEntrySet()) {
                weightNBT.m_128350_((String)e.getKey(), e.getFloatValue());
            }
            nbt.m_128365_("Weights", (Tag)weightNBT);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.excludes.clear();
        ListTag excludeNBT = nbt.m_128437_("Excludes", 8);
        for (int i = 0; i < excludeNBT.size(); ++i) {
            this.excludes.add(excludeNBT.m_128778_(i));
        }
        if (nbt.m_128425_("Weights", 10)) {
            CompoundTag weightNBT = nbt.m_128469_("Weights");
            this.boneWeights = new Object2FloatOpenHashMap();
            for (String key : weightNBT.m_128431_()) {
                this.boneWeights.put((Object)key, weightNBT.m_128457_(key));
            }
        }
    }

    public WeightFunction getBoneWeight() {
        return this.boneWeights == null ? WeightFunction.ONE : b -> this.boneWeights.getOrDefault((Object)b, 1.0f);
    }

    public static SerializableMaskBuilder builder() {
        return new SerializableMaskBuilder();
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public Object2FloatMap<String> getBoneWeights() {
        return this.boneWeights;
    }

    public SerializableMask(Set<String> excludes, Object2FloatMap<String> boneWeights) {
        this.excludes = excludes;
        this.boneWeights = boneWeights;
    }

    public SerializableMask() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializableMask)) {
            return false;
        }
        SerializableMask other = (SerializableMask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$excludes = this.getExcludes();
        Set<String> other$excludes = other.getExcludes();
        if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
            return false;
        }
        Object2FloatMap<String> this$boneWeights = this.getBoneWeights();
        Object2FloatMap<String> other$boneWeights = other.getBoneWeights();
        return !(this$boneWeights == null ? other$boneWeights != null : !this$boneWeights.equals(other$boneWeights));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SerializableMask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        Object2FloatMap<String> $boneWeights = this.getBoneWeights();
        result = result * 59 + ($boneWeights == null ? 43 : $boneWeights.hashCode());
        return result;
    }

    public static interface WeightFunction {
        public static final WeightFunction ONE = t -> 1.0f;

        public float get(String var1);
    }

    public static class SerializableMaskBuilder {
        private ArrayList<String> excludes;
        private Object2FloatMap<String> boneWeights;

        public SerializableMaskBuilder excludeAll(String ... bones) {
            return this.excludes(Arrays.asList(bones));
        }

        public SerializableMaskBuilder boneWeight(String bone, float weight) {
            if (Math.abs(weight) < 1.0E-30f) {
                return this.exclude(bone);
            }
            this.boneWeights().put((Object)bone, weight);
            return this;
        }

        private Object2FloatMap<String> boneWeights() {
            if (this.boneWeights != null) {
                return this.boneWeights;
            }
            this.boneWeights = new Object2FloatOpenHashMap();
            return this.boneWeights;
        }

        SerializableMaskBuilder() {
        }

        public SerializableMaskBuilder exclude(String exclude) {
            if (this.excludes == null) {
                this.excludes = new ArrayList();
            }
            this.excludes.add(exclude);
            return this;
        }

        public SerializableMaskBuilder excludes(Collection<? extends String> excludes) {
            if (excludes == null) {
                throw new NullPointerException("excludes cannot be null");
            }
            if (this.excludes == null) {
                this.excludes = new ArrayList();
            }
            this.excludes.addAll(excludes);
            return this;
        }

        public SerializableMaskBuilder clearExcludes() {
            if (this.excludes != null) {
                this.excludes.clear();
            }
            return this;
        }

        public SerializableMask build() {
            Set<String> excludes;
            switch (this.excludes == null ? 0 : this.excludes.size()) {
                case 0: {
                    excludes = Collections.emptySet();
                    break;
                }
                case 1: {
                    excludes = Collections.singleton(this.excludes.get(0));
                    break;
                }
                default: {
                    excludes = new LinkedHashSet<String>(this.excludes.size() < 0x40000000 ? 1 + this.excludes.size() + (this.excludes.size() - 3) / 3 : Integer.MAX_VALUE);
                    excludes.addAll(this.excludes);
                    excludes = Collections.unmodifiableSet(excludes);
                }
            }
            return new SerializableMask(excludes, this.boneWeights);
        }

        public String toString() {
            return "SerializableMask.SerializableMaskBuilder(excludes=" + this.excludes + ", boneWeights=" + this.boneWeights + ")";
        }
    }
}

