/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedParticleEffect;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedSoundEffect;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.geometry.model.IPositionalModel;
import org.zeith.hammeranims.api.particles.emitter.IParticleRotationUpdater;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;

public interface IAnimatedObject {
    default public float getAnimatedObjectScale() {
        return 1.0f;
    }

    default public float getAnimatedObjectWidth() {
        return 1.0f;
    }

    default public float getAnimatedObjectHeight() {
        return 1.0f;
    }

    default public float getAnimatedObjectDepth() {
        return this.getAnimatedObjectWidth();
    }

    default public float getAnimationObjectVolume() {
        return 1.0f;
    }

    default public SoundSource getAnimationObjectSoundCategory() {
        if (this instanceof Enemy) {
            return SoundSource.HOSTILE;
        }
        if (this instanceof BlockEntity) {
            return SoundSource.BLOCKS;
        }
        return SoundSource.NEUTRAL;
    }

    public void setupSystem(AnimationSystem.Builder var1);

    public AnimationSystem getAnimationSystem();

    public IObjectSource<?> getAnimationSource();

    public Level getAnimatedObjectWorld();

    public Vec3 getAnimatedObjectPosition();

    default public IGeometryContainer getObjectModel() {
        return DefaultsHA.NULL_GEOMETRY;
    }

    default public Matrix4d getAnimatedLocatorMatrix(String locator, float partialTicks) {
        Vec3 pos = this.getAnimatedObjectPosition();
        if (pos == null) {
            return null;
        }
        Matrix4d mat = new Matrix4d().identity().translate(pos.f_82479_ + 0.5, pos.f_82480_, pos.f_82481_ + 0.5).rotateY(0.0);
        if (locator == null || locator.isEmpty()) {
            return mat;
        }
        IPositionalModel posMod = this.getObjectModel().getPositionalModel();
        posMod.applySystem(partialTicks, this.getAnimationSystem());
        if (posMod.applyLocatorTransforms(mat, locator)) {
            return mat;
        }
        return null;
    }

    default public Vec3 getAnimatedLocatorPosition(String locator, float partialTicks) {
        Matrix4d mat = this.getAnimatedLocatorMatrix(locator, partialTicks);
        if (mat != null) {
            Vector3d vpos = mat.transformPosition(new Vector3d(0.0));
            return new Vec3(vpos.x, vpos.y, vpos.z);
        }
        return null;
    }

    default public void playSound(AnimatedSoundEffect effect) {
        Level world = this.getAnimatedObjectWorld();
        Vec3 pos = this.getAnimatedObjectPosition();
        if (world == null || pos == null || !world.m_5776_()) {
            return;
        }
        float vol = this.getAnimationObjectVolume();
        if (vol <= 0.0f) {
            return;
        }
        world.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(effect.getEffect()), this.getAnimationObjectSoundCategory(), 1.0f, 1.0f, false);
    }

    default public Matrix3f getParticleEffectRotation(AnimatedParticleEffect effect) {
        Matrix4d mat = this.getAnimatedLocatorMatrix(effect.getLocator(), 1.0f);
        if (mat == null) {
            return null;
        }
        Matrix3f rot = new Matrix3f();
        rot.rotate((Quaternionfc)mat.getNormalizedRotation(new Quaternionf()));
        return rot;
    }

    default public IParticleRotationUpdater playParticle(AnimatedParticleEffect effect) {
        Level world = this.getAnimatedObjectWorld();
        Matrix4d mat = this.getAnimatedLocatorMatrix(effect.getLocator(), 1.0f);
        if (world == null || mat == null || !world.f_46443_) {
            return null;
        }
        Vector3d vpos = mat.transformPosition(new Vector3d(0.0));
        Matrix3f rot = this.getParticleEffectRotation(effect);
        return HammerAnimations.PROXY.createParticle(effect, rot, new Vec3(vpos.x, vpos.y, vpos.z));
    }
}

