/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.zeith.hammeranims.api.animation.Animation;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.LoopMode;
import org.zeith.hammeranims.api.animsys.SerializableMask;
import org.zeith.hammeranims.api.animsys.actions.AnimationAction;
import org.zeith.hammeranims.api.animsys.actions.AnimationActionInstance;
import org.zeith.hammeranims.api.animsys.layer.ActiveAnimation;
import org.zeith.hammeranims.api.animsys.layer.AnimationLayer;
import org.zeith.hammeranims.api.time.TimeFunction;
import org.zeith.hammeranims.api.time.TimeFunctionInstance;
import org.zeith.hammeranims.api.utils.ICompoundSerializable;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammeranims.core.utils.InstanceHelpers;

public class ConfiguredAnimation
implements ICompoundSerializable {
    public Animation animation;
    public float weight = 1.0f;
    public float speed = 1.0f;
    public float startTime = 0.0f;
    public boolean reverse = false;
    public float transitionTime = 0.25f;
    public TimeFunctionInstance timeFunction = TimeFunctionInstance.EMPTY;
    public boolean important = false;
    public LoopMode loopMode = LoopMode.ONCE;
    public SerializableMask mask = null;
    public ConfiguredAnimation next;
    public final List<AnimationActionInstance> onFinish = new ArrayList<AnimationActionInstance>();

    public static ConfiguredAnimation noAnimation() {
        return DefaultsHA.NULL_ANIMATION_SYNTETIC.configure();
    }

    public ConfiguredAnimation(ConfiguredAnimation toCopy) {
        this(toCopy.serializeNBT());
    }

    public ConfiguredAnimation(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public ConfiguredAnimation(Animation animation) {
        this.setAnimation(animation);
    }

    public Animation getAnimation() {
        return this.animation != null ? this.animation : DefaultsHA.NULL_ANIMATION_SYNTETIC;
    }

    public boolean same(ConfiguredAnimation other) {
        return this.speed == other.speed && this.weight == other.weight && this.loopMode == other.loopMode && this.startTime == other.startTime && this.transitionTime == other.transitionTime && this.timeFunction.equals(other.timeFunction) && Objects.equals(this.mask, other.mask) && this.reverse == other.reverse && this.animation == other.animation;
    }

    public void setAnimation(Animation animation) {
        if (animation == null) {
            animation = DefaultsHA.NULL_ANIMATION_SYNTETIC;
        }
        this.animation = animation;
        this.loopMode = animation.getData().getLoopMode();
    }

    public ConfiguredAnimation mask(SerializableMask mask) {
        this.mask = mask;
        return this;
    }

    public ConfiguredAnimation weight(float weight) {
        this.weight = weight;
        return this;
    }

    public ConfiguredAnimation onFinish(AnimationActionInstance action) {
        if (action == null || action.isEmpty()) {
            return this;
        }
        this.onFinish.add(action);
        return this;
    }

    public ConfiguredAnimation onFinish(AnimationAction action) {
        return this.onFinish(action.defaultInstance());
    }

    public ConfiguredAnimation speed(float speed) {
        this.speed = speed;
        return this;
    }

    public ConfiguredAnimation startTime(float startTime) {
        this.startTime = startTime;
        return this;
    }

    public ConfiguredAnimation freezeAt(float time) {
        return this.startTime(time).speed(0.0f);
    }

    public ConfiguredAnimation reversed(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public ConfiguredAnimation reversed() {
        return this.reversed(true);
    }

    public ConfiguredAnimation transitionTime(float transitionTime) {
        this.transitionTime = transitionTime;
        return this;
    }

    public ConfiguredAnimation transitionTime(Duration transitionTime) {
        this.transitionTime = (float)transitionTime.toMillis() / 1000.0f;
        return this;
    }

    public ConfiguredAnimation timeFunction(TimeFunction timeFunction) {
        this.timeFunction = timeFunction.defaultInstance();
        return this;
    }

    public ConfiguredAnimation timeFunction(TimeFunctionInstance timeFunction) {
        this.timeFunction = timeFunction;
        return this;
    }

    public ConfiguredAnimation loopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
        return this;
    }

    public ConfiguredAnimation important() {
        this.important = true;
        return this;
    }

    public ConfiguredAnimation important(boolean important) {
        this.important = important;
        return this;
    }

    public ConfiguredAnimation next(ConfiguredAnimation next) {
        this.next = next;
        return this;
    }

    public AnimationLocation getLocation() {
        return this.animation != null ? this.animation.getLocation() : null;
    }

    public ActiveAnimation activate(AnimationLayer layer) {
        ActiveAnimation aa = new ActiveAnimation(this);
        aa.activationTime = layer.startTime;
        return aa;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = InstanceHelpers.newNBTCompound();
        if (this.mask != null) {
            tag.m_128365_("Mask", (Tag)this.mask.serializeNBT());
        }
        tag.m_128365_("Time", (Tag)this.timeFunction.serializeNBT());
        tag.m_128359_("Animation", this.animation.getLocation().toString());
        tag.m_128350_("Weight", this.weight);
        tag.m_128379_("Reverse", this.reverse);
        tag.m_128350_("Speed", this.speed);
        tag.m_128350_("StartTime", this.startTime);
        tag.m_128350_("TransitionTime", this.transitionTime);
        if (this.next != null) {
            tag.m_128365_("Next", (Tag)this.next.serializeNBT());
        }
        tag.m_128344_("LoopMode", (byte)(this.loopMode != null ? this.loopMode.ordinal() : LoopMode.ONCE.ordinal()));
        if (!this.onFinish.isEmpty()) {
            ListTag onFinish = InstanceHelpers.newNBTList();
            for (AnimationActionInstance finish : this.onFinish) {
                onFinish.add((Object)finish.serializeNBT());
            }
            tag.m_128365_("OnFinish", (Tag)onFinish);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.timeFunction = TimeFunctionInstance.of(tag.m_128469_("Time"));
        this.mask = tag.m_128425_("Mask", 10) ? new SerializableMask(tag.m_128469_("Mask")) : null;
        this.setAnimation(new AnimationLocation(tag.m_128461_("Animation")).resolve().orElse(null));
        this.weight = tag.m_128457_("Weight");
        this.reverse = tag.m_128471_("Reverse");
        this.speed = tag.m_128457_("Speed");
        this.startTime = tag.m_128457_("StartTime");
        this.transitionTime = tag.m_128457_("TransitionTime");
        if (tag.m_128425_("Next", 10)) {
            this.next = new ConfiguredAnimation(tag.m_128469_("Next"));
        }
        this.loopMode = LoopMode.values()[tag.m_128445_("LoopMode") % LoopMode.VALUE_COUNT];
        ListTag onFinish = tag.m_128437_("OnFinish", 10);
        this.onFinish.clear();
        for (int i = 0; i < onFinish.size(); ++i) {
            AnimationActionInstance a = AnimationActionInstance.of(onFinish.m_128728_(i));
            if (a == null || a.isEmpty()) continue;
            this.onFinish.add(a);
        }
    }
}

