/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animsys;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.IAnimationSource;
import org.zeith.hammeranims.api.animsys.ConfiguredAnimation;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammeranims.api.animsys.layer.AnimationLayer;
import org.zeith.hammeranims.api.geometry.model.GeometryPose;
import org.zeith.hammeranims.api.utils.ICompoundSerializable;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammeranims.core.utils.InstanceHelpers;
import org.zeith.hammeranims.net.PacketRequestAnimationSystemSync;
import org.zeith.hammeranims.net.PacketSyncAnimationSystem;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;

public class AnimationSystem
implements ICompoundSerializable {
    @Nonnull
    public final IAnimatedObject owner;
    protected double time;
    protected boolean hasTicked = false;
    protected boolean hasReceivedTime = false;
    public boolean canSync = true;
    public boolean autoSync = false;
    public boolean syncTime = true;
    protected final AnimationLayer[] layers;
    protected final Map<String, AnimationLayer> layerMap;

    public AnimationSystem(@Nonnull IAnimatedObject owner, AnimationLayer[] layers, Map<String, AnimationLayer> layerMap) {
        this.owner = owner;
        this.layers = layers;
        this.layerMap = Collections.unmodifiableMap(layerMap);
    }

    public IPacket createSyncPacket() {
        return new PacketSyncAnimationSystem(this);
    }

    public void sync() {
        Level world = this.owner.getAnimatedObjectWorld();
        if (this.owner.getAnimatedObjectWorld().f_46443_ || !this.canSync) {
            return;
        }
        BlockPos pos = BlockPos.m_274446_((Position)this.owner.getAnimatedObjectPosition());
        if (!world.m_46749_(pos)) {
            return;
        }
        Network.sendToTracking((IPacket)this.createSyncPacket(), (LevelChunk)world.m_46745_(pos));
    }

    @Nullable
    public AnimationLayer getLayer(String name) {
        return this.layerMap.get(name);
    }

    public AnimationLocation activeAnimationLocation(String layer) {
        AnimationLayer l = this.getLayer(layer);
        return l == null ? DefaultsHA.NULL_ANIM.getLocation() : l.activeAnimationLocation();
    }

    public boolean isActiveAnimation(String layer, IAnimationSource source) {
        AnimationLocation al = this.activeAnimationLocation(layer);
        return Objects.equals(al, source.getLocation());
    }

    public boolean startAnimationAt(String layer, IAnimationSource animation) {
        return this.startAnimationAt(layer, animation.configure());
    }

    public boolean startAnimationAt(String layer, ConfiguredAnimation animation) {
        AnimationLayer l = this.layerMap.get(layer);
        if (l != null) {
            return l.startAnimation(animation);
        }
        return false;
    }

    public boolean stopAnimation(String layer) {
        return this.startAnimationAt(layer, ConfiguredAnimation.noAnimation());
    }

    public boolean stopAnimation(String layer, float transitionTime) {
        return this.startAnimationAt(layer, ConfiguredAnimation.noAnimation().transitionTime(transitionTime));
    }

    public boolean stopAnimation(String layer, Duration transitionTime) {
        return this.startAnimationAt(layer, ConfiguredAnimation.noAnimation().transitionTime(transitionTime));
    }

    public Set<String> getLayerNames() {
        return this.layerMap.keySet();
    }

    public Set<Map.Entry<String, AnimationLayer>> entrySet() {
        return this.layerMap.entrySet();
    }

    public void tick() {
        if (!this.hasTicked) {
            this.hasTicked = true;
            if (this.canSync && this.owner.getAnimatedObjectWorld().m_5776_()) {
                Network.sendToServer((IPacket)new PacketRequestAnimationSystemSync(this));
            }
        }
        this.time += 0.05;
        for (AnimationLayer layer : this.layers) {
            layer.tick(this.time);
        }
    }

    public void resetTime() {
        this.time = 0.0;
        for (AnimationLayer layer : this.layers) {
            layer.startTime = 0.0;
        }
    }

    public double getTime(float partialTicks) {
        return this.time + 0.05 * (double)partialTicks;
    }

    public void applyAnimation(float partialTicks, GeometryPose pose) {
        double sysTime = this.getTime(partialTicks);
        for (AnimationLayer layer : this.layers) {
            layer.applyAnimation(sysTime, partialTicks, pose);
        }
    }

    public void applyAnimation(float partialTicks, GeometryPose pose, Predicate<AnimationLayer> layerMask) {
        double sysTime = this.getTime(partialTicks);
        for (AnimationLayer layer : this.layers) {
            if (!layerMask.test(layer)) continue;
            layer.applyAnimation(sysTime, partialTicks, pose);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag comp = InstanceHelpers.newNBTCompound();
        comp.m_128347_("Time", this.time);
        ListTag layers = InstanceHelpers.newNBTList();
        for (AnimationLayer layer : this.layers) {
            if (!layer.persistent) continue;
            layers.add((Object)layer.serializeNBT());
        }
        comp.m_128365_("Layers", (Tag)layers);
        return comp;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (this.syncTime || !this.hasReceivedTime) {
            this.time = nbt.m_128459_("Time");
            this.hasReceivedTime = true;
        }
        ListTag layers = nbt.m_128437_("Layers", 10);
        for (int i = 0; i < layers.size(); ++i) {
            CompoundTag tag = layers.m_128728_(i);
            AnimationLayer l = this.layerMap.get(tag.m_128461_("Name"));
            if (l == null || !l.persistent) continue;
            l.deserializeNBT(tag);
        }
    }

    public static AnimationSystem create(IAnimatedObject obj) {
        Builder builder = AnimationSystem.builder(obj);
        obj.setupSystem(builder);
        return builder.build();
    }

    public static Builder builder(@Nonnull IAnimatedObject owner) {
        return new Builder(Objects.requireNonNull(owner));
    }

    public void setTime(double time) {
        this.time = time;
    }

    public AnimationLayer[] getLayers() {
        return this.layers;
    }

    public static class Builder {
        @Nonnull
        protected final IAnimatedObject owner;
        protected boolean canSync = true;
        protected boolean autoSync = false;
        protected boolean syncTime = true;
        protected final List<AnimationLayer.Builder> layers = new ArrayList<AnimationLayer.Builder>();

        public Builder(@Nonnull IAnimatedObject owner) {
            this.owner = owner;
        }

        public Builder addLayers(AnimationLayer.Builder ... layers) {
            this.layers.addAll(Arrays.asList(layers));
            return this;
        }

        public Builder addLayers(String ... names) {
            this.layers.addAll(Stream.of(names).map(AnimationLayer::builder).collect(Collectors.toList()));
            return this;
        }

        public Builder disableSync() {
            this.canSync = false;
            return this;
        }

        public Builder autoSync() {
            this.autoSync = true;
            return this;
        }

        public Builder syncTime(boolean syncTime) {
            this.syncTime = syncTime;
            return this;
        }

        public Builder autoSync(boolean autoSync) {
            this.autoSync = autoSync;
            return this;
        }

        public AnimationSystem build() {
            AnimationLayer[] layers = new AnimationLayer[this.layers.size()];
            HashMap<String, AnimationLayer> layerMap = new HashMap<String, AnimationLayer>();
            AnimationSystem sys = new AnimationSystem(this.owner, layers, layerMap);
            for (int i = 0; i < layers.length; ++i) {
                AnimationLayer al = layers[i] = this.layers.get(i).build(sys);
                layerMap.put(al.name, al);
            }
            sys.canSync = this.canSync;
            sys.autoSync = this.autoSync;
            sys.syncTime = this.syncTime;
            return sys;
        }
    }
}

