/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation.interp;

import java.util.function.Function;
import net.minecraft.world.phys.Vec3;
import org.zeith.hammeranims.api.animation.interp.BaseInterpolation;
import org.zeith.hammeranims.api.animation.interp.DoubleInterpolation;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.animation.interp.Query;

public class Vec3Animation {
    public static final Vec3Animation ZERO = new Vec3Animation(new DoubleInterpolation(InterpolatedDouble.constant(0.0)));
    public static final Vec3Animation ONE = new Vec3Animation(new DoubleInterpolation(InterpolatedDouble.constant(1.0)));
    protected final BaseInterpolation animation;
    protected final Function<Query, Vec3> eval;

    public Vec3Animation(BaseInterpolation a) {
        this.animation = a;
        int c = this.animation.getDoubleCount();
        this.eval = c >= 3 ? q -> {
            double[] data = this.animation.get((Query)q);
            return new Vec3(data[0], data[1], data[2]);
        } : q -> {
            double i = this.animation.get((Query)q)[0];
            return new Vec3(i, i, i);
        };
    }

    public Vec3 get(Query q) {
        return this.eval.apply(q);
    }

    public static Vec3Animation parse(Object obj) {
        BaseInterpolation parse = BaseInterpolation.parse(obj);
        if (parse == null) {
            return null;
        }
        return new Vec3Animation(parse);
    }

    public String toString() {
        return "Vec3Animation{" + this.animation + "}";
    }
}

