/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation.interp;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import org.zeith.hammeranims.api.animation.data.IAnimationData;
import org.zeith.hammeranims.api.animation.interp.BaseInterpolation;
import org.zeith.hammeranims.api.animation.interp.Query;
import org.zeith.hammeranims.api.animation.interp.keyframes.CatmullRomKeyFrame;
import org.zeith.hammeranims.api.animation.interp.keyframes.IKeyFrame;
import org.zeith.hammeranims.api.animation.interp.keyframes.KeyFrame;
import org.zeith.hammeranims.api.animation.interp.keyframes.StepKeyFrame;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.hammerlib.util.shaded.json.JSONArray;
import org.zeith.hammerlib.util.shaded.json.JSONException;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class KeyframeInterpolation
extends BaseInterpolation {
    public final int doubleCount;
    public final DoubleList keyframeTimes;
    public final List<IKeyFrame> keyframes;

    public KeyframeInterpolation(int doubleCount, DoubleList keyframeTimes, List<IKeyFrame> keyframes) {
        this.doubleCount = doubleCount;
        this.keyframeTimes = keyframeTimes;
        this.keyframes = keyframes;
    }

    public boolean validate(IAnimationData data) {
        double seconds = (double)data.getLength().toMillis() / 1000.0;
        double prev = Double.NEGATIVE_INFINITY;
        DoubleListIterator doubleListIterator = this.keyframeTimes.iterator();
        while (doubleListIterator.hasNext()) {
            double ds = (Double)doubleListIterator.next();
            if (ds > seconds || ds < 0.0) {
                return false;
            }
            if (prev > ds) {
                return false;
            }
            prev = ds;
        }
        return true;
    }

    public String toString() {
        return "KeyframeInterpolation" + this.keyframes;
    }

    @Override
    public int getDoubleCount() {
        return this.doubleCount;
    }

    @Override
    public double[] get(Query query) {
        IKeyFrame next;
        int index = KeyframeInterpolation.findInsertionIndex(this.keyframeTimes, query.anim_time);
        int fromIdx = index - 1;
        int toIdx = index % this.keyframes.size();
        if (fromIdx < 0) {
            fromIdx += this.keyframes.size();
        }
        IKeyFrame prev = this.keyframes.get(fromIdx);
        IKeyFrame iKeyFrame = next = toIdx > fromIdx ? this.keyframes.get(toIdx) : null;
        if (next == null) {
            return prev.getVec(IKeyFrame.KeyFrameState.PREV).get(query);
        }
        if (prev == null) {
            return next.getVec(IKeyFrame.KeyFrameState.NEXT).get(query);
        }
        if (prev instanceof CatmullRomKeyFrame || next instanceof CatmullRomKeyFrame) {
            return this.interpolateSmoothly(prev, next, fromIdx, toIdx, query);
        }
        return KeyframeInterpolation.interpolateLinear(prev, next, query);
    }

    public static double[] interpolateLinear(IKeyFrame prev, IKeyFrame next, Query query) {
        if (next == null) {
            return prev.getVec(IKeyFrame.KeyFrameState.PREV).get(query);
        }
        double duration = next.getTime() - prev.getTime();
        double iv = (query.anim_time - prev.getTime()) / duration;
        double[] a = prev.getVec(IKeyFrame.KeyFrameState.PREV).get(query);
        double[] b = next.getVec(IKeyFrame.KeyFrameState.NEXT).get(query);
        double[] res = new double[Math.min(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Mth.m_14139_((double)iv, (double)a[i], (double)b[i]);
        }
        return res;
    }

    private double[] interpolateSmoothly(IKeyFrame prev, IKeyFrame next, int prevIndex, int nextIndex, Query query) {
        IKeyFrame beforeMinus = null;
        if (prevIndex > 0) {
            beforeMinus = this.keyframes.get(prevIndex - 1);
        }
        IKeyFrame afterPlus = null;
        if (nextIndex < this.keyframes.size() - 1) {
            afterPlus = this.keyframes.get(nextIndex + 1);
        }
        return KeyframeInterpolation.catmullRom(beforeMinus, prev, next, afterPlus, query);
    }

    private static double[] catmullRom(@Nullable IKeyFrame beforeMinus, @Nullable IKeyFrame before, @Nullable IKeyFrame after, @Nullable IKeyFrame afterPlus, Query query) {
        double factor = KeyframeInterpolation.percentage(query.anim_time, before != null ? before.getTime() : 0.0, after != null ? after.getTime() : query.anim_duration);
        return KeyframeInterpolation.catmullRom(beforeMinus, before, after, afterPlus, factor, query);
    }

    private static double[] catmullRom(@Nullable IKeyFrame beforeMinus, @Nullable IKeyFrame before, @Nullable IKeyFrame after, @Nullable IKeyFrame afterPlus, double factor, Query query) {
        int allocatedSize = KeyframeInterpolation.countNonNls(beforeMinus, before, after, afterPlus);
        BaseInterpolation[] points = new BaseInterpolation[allocatedSize];
        int index = 0;
        if (beforeMinus != null) {
            points[index++] = beforeMinus.getVec(IKeyFrame.KeyFrameState.PREV);
        }
        if (before != null) {
            points[index++] = before.getVec(IKeyFrame.KeyFrameState.PREV);
        }
        if (after != null) {
            points[index++] = after.getVec(IKeyFrame.KeyFrameState.NEXT);
        }
        if (afterPlus != null) {
            points[index] = afterPlus.getVec(IKeyFrame.KeyFrameState.NEXT);
        }
        double time = (factor + (double)(beforeMinus != null ? 1 : 0)) / (double)(allocatedSize - 1);
        return KeyframeInterpolation.catmullRom(time, points, query);
    }

    private static int countNonNls(@Nullable Object o1, @Nullable Object o2, @Nullable Object o3, @Nullable Object o4) {
        int count = 0;
        if (o1 != null) {
            ++count;
        }
        if (o2 != null) {
            ++count;
        }
        if (o3 != null) {
            ++count;
        }
        if (o4 != null) {
            ++count;
        }
        return count;
    }

    private static double[] catmullRom(double weightIn, BaseInterpolation[] points, Query query) {
        double p = (double)(points.length - 1) * weightIn;
        int intPoint = (int)Math.floor(p);
        double weight = p - (double)intPoint;
        double[] p0 = points[intPoint == 0 ? intPoint : intPoint - 1].get(query);
        double[] p1 = points[intPoint].get(query);
        double[] p2 = points[intPoint > points.length - 2 ? points.length - 1 : intPoint + 1].get(query);
        double[] p3 = points[intPoint > points.length - 3 ? points.length - 1 : intPoint + 2].get(query);
        double[] iv = new double[p0.length];
        for (int i = 0; i < iv.length; ++i) {
            iv[i] = KeyframeInterpolation.catmullRom(weight, p0[i], p1[i], p2[i], p3[i]);
        }
        return iv;
    }

    private static double catmullRom(double t, double p0, double p1, double p2, double p3) {
        double v0 = (p2 - p0) * 0.5;
        double v1 = (p3 - p1) * 0.5;
        double t2 = t * t;
        double t3 = t * t2;
        return (2.0 * p1 - 2.0 * p2 + v0 + v1) * t3 + (-3.0 * p1 + 3.0 * p2 - 2.0 * v0 - v1) * t2 + v0 * t + p1;
    }

    public static double percentage(double current, double start, double end) {
        return end - start != 0.0 ? (current - start) / (end - start) : 1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyframeInterpolation parse(int doubleCount, JSONObject json) {
        DoubleArrayList keyframeTimes = new DoubleArrayList(json.length());
        ArrayList<IKeyFrame> keyframes = new ArrayList<IKeyFrame>(json.length());
        Iterator itr = json.keySet().stream().map(str -> Tuples.immutable((Object)str, (Object)Double.parseDouble(str))).sorted(Comparator.comparingDouble(Tuple2::b)).iterator();
        while (itr.hasNext()) {
            IKeyFrame kf;
            Tuple2 s = (Tuple2)itr.next();
            double time = (Double)s.b();
            Object o = json.get((String)s.a());
            if (o instanceof JSONObject) {
                JSONObject frame = (JSONObject)o;
                if (frame.has("pre")) {
                    BaseInterpolation pre = BaseInterpolation.parse(frame.get("pre"));
                    BaseInterpolation post = BaseInterpolation.parse(frame.get("post"));
                    kf = new StepKeyFrame(time, pre, post);
                } else {
                    String lerpMode = frame.optString("lerp_mode");
                    BaseInterpolation vec = BaseInterpolation.parse(frame.opt("post"));
                    if (lerpMode.equalsIgnoreCase("catmullrom")) {
                        kf = new CatmullRomKeyFrame(time, vec);
                    } else {
                        if (!lerpMode.equalsIgnoreCase("linear")) throw new JSONException("Invalid lerp_mode found: " + lerpMode);
                        kf = new KeyFrame(time, vec);
                    }
                }
            } else {
                if (!(o instanceof JSONArray)) throw new JSONException("Invalid keyframe at " + (String)s.a() + " found: " + o);
                BaseInterpolation a = BaseInterpolation.parse(o);
                if (a == null) {
                    return null;
                }
                if (a.getDoubleCount() < doubleCount) {
                    return null;
                }
                kf = new KeyFrame(time, a);
            }
            if (keyframes.isEmpty() && time > 0.0) {
                keyframes.add(kf.withNewTime(0.0));
                keyframeTimes.add(0.0);
            }
            keyframes.add(kf);
            keyframeTimes.add(time);
        }
        return new KeyframeInterpolation(doubleCount, (DoubleList)keyframeTimes, keyframes);
    }

    private static int findInsertionIndex(DoubleList list, double x) {
        int low = 0;
        int high = list.size();
        while (low < high) {
            int mid = low + (high - low) / 2;
            if (list.getDouble(mid) < x) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }
}

