/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation.interp;

import com.google.gson.JsonElement;
import org.zeith.hammeranims.api.animation.interp.IVariableAccess;
import org.zeith.hammeranims.core.js.ExpressionParser;

@FunctionalInterface
public interface InterpolatedDouble<T extends IVariableAccess> {
    public double get(T var1);

    public static <T extends IVariableAccess> InterpolatedDouble<T> one() {
        return InterpolatedDouble.constant(1.0);
    }

    public static <T extends IVariableAccess> InterpolatedDouble<T> zero() {
        return InterpolatedDouble.constant(0.0);
    }

    public static <T extends IVariableAccess> InterpolatedDouble<T> constant(double d) {
        return query -> d;
    }

    public static <T extends IVariableAccess> InterpolatedDouble<T> parse(String expression) {
        return ExpressionParser.parse(expression);
    }

    public static <T extends IVariableAccess> InterpolatedDouble<T> parse(Object o) {
        if (o instanceof Number) {
            return InterpolatedDouble.constant(((Number)o).doubleValue());
        }
        if (o instanceof String) {
            return InterpolatedDouble.parse((String)o);
        }
        if (o instanceof JsonElement) {
            JsonElement e = (JsonElement)o;
            return InterpolatedDouble.parse(e.getAsString());
        }
        return null;
    }

    public static class NumberWrapped<T extends IVariableAccess>
    extends Number
    implements InterpolatedDouble<T> {
        protected final InterpolatedDouble<T> id;
        protected Double value = 0.0;

        public NumberWrapped(InterpolatedDouble<T> id) {
            this.id = id;
        }

        public void update(T access) {
            this.value = this.id.get(access);
        }

        @Override
        public int intValue() {
            return this.value.intValue();
        }

        @Override
        public long longValue() {
            return this.value.longValue();
        }

        @Override
        public float floatValue() {
            return this.value.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public double get(T query) {
            return this.id.get(query);
        }
    }
}

