/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation.data.effects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.core.utils.InstanceHelpers;
import org.zeith.hammerlib.util.shaded.json.JSONArray;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public final class AnimatedParticleEffect {
    private final ResourceLocation effect;
    private final String locator;
    private final String pre_effect_script;

    public IParticleContainer getParticle() {
        return IParticleContainer.byRegistryKey(this.effect);
    }

    public static List<AnimatedParticleEffect> decode(Object object) {
        if (object instanceof JSONArray) {
            ArrayList<AnimatedParticleEffect> lst = new ArrayList<AnimatedParticleEffect>();
            for (Object value : (JSONArray)object) {
                lst.addAll(AnimatedParticleEffect.decode(value));
            }
            return Collections.unmodifiableList(lst);
        }
        if (object instanceof JSONObject) {
            JSONObject ob = (JSONObject)object;
            return Collections.singletonList(new AnimatedParticleEffect(InstanceHelpers.tryParseLocation(((JSONObject)object).getString("effect")), ob.optString("locator"), ob.optString("pre_effect_script")));
        }
        return Collections.emptyList();
    }

    public AnimatedParticleEffect(ResourceLocation effect, String locator, String pre_effect_script) {
        this.effect = effect;
        this.locator = locator;
        this.pre_effect_script = pre_effect_script;
    }

    public ResourceLocation getEffect() {
        return this.effect;
    }

    public String getLocator() {
        return this.locator;
    }

    public String getPre_effect_script() {
        return this.pre_effect_script;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimatedParticleEffect)) {
            return false;
        }
        AnimatedParticleEffect other = (AnimatedParticleEffect)o;
        ResourceLocation this$effect = this.getEffect();
        ResourceLocation other$effect = other.getEffect();
        if (this$effect == null ? other$effect != null : !this$effect.equals(other$effect)) {
            return false;
        }
        String this$locator = this.getLocator();
        String other$locator = other.getLocator();
        if (this$locator == null ? other$locator != null : !this$locator.equals(other$locator)) {
            return false;
        }
        String this$pre_effect_script = this.getPre_effect_script();
        String other$pre_effect_script = other.getPre_effect_script();
        return !(this$pre_effect_script == null ? other$pre_effect_script != null : !this$pre_effect_script.equals(other$pre_effect_script));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : $effect.hashCode());
        String $locator = this.getLocator();
        result = result * 59 + ($locator == null ? 43 : $locator.hashCode());
        String $pre_effect_script = this.getPre_effect_script();
        result = result * 59 + ($pre_effect_script == null ? 43 : $pre_effect_script.hashCode());
        return result;
    }

    public String toString() {
        return "AnimatedParticleEffect(effect=" + this.getEffect() + ", locator=" + this.getLocator() + ", pre_effect_script=" + this.getPre_effect_script() + ")";
    }
}

