/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation.data;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.zeith.hammeranims.api.animation.LoopMode;
import org.zeith.hammeranims.api.animation.data.BoneAnimation;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedParticleEffect;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedSoundEffect;

public interface IAnimationData {
    public static final IAnimationData EMPTY = new IAnimationData(){

        @Override
        public LoopMode getLoopMode() {
            return LoopMode.ONCE;
        }

        @Override
        public Duration getLength() {
            return Duration.ZERO;
        }

        @Override
        public Map<String, BoneAnimation> getBoneAnimations() {
            return Collections.emptyMap();
        }

        @Override
        public Int2ObjectMap<List<AnimatedSoundEffect>> getSoundEffects() {
            return Int2ObjectMaps.emptyMap();
        }

        @Override
        public Int2ObjectMap<List<AnimatedParticleEffect>> getParticleEffects() {
            return Int2ObjectMaps.emptyMap();
        }

        @Override
        public float getWeight() {
            return 1.0f;
        }
    };

    public LoopMode getLoopMode();

    public Duration getLength();

    public Map<String, BoneAnimation> getBoneAnimations();

    public Int2ObjectMap<List<AnimatedSoundEffect>> getSoundEffects();

    public Int2ObjectMap<List<AnimatedParticleEffect>> getParticleEffects();

    default public double getLengthSeconds() {
        return (double)this.getLength().toMillis() / 1000.0;
    }

    public float getWeight();
}

