/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation.data;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.interp.BlendMode;
import org.zeith.hammeranims.api.animation.interp.Query;
import org.zeith.hammeranims.api.animation.interp.Vec3Animation;
import org.zeith.hammeranims.api.geometry.model.GeometryTransforms;
import org.zeith.hammerlib.util.java.functions.Function3;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class BoneAnimation {
    @Nonnull
    public final Vec3Animation rotation;
    @Nonnull
    public final Vec3Animation position;
    @Nonnull
    public final Vec3Animation scale;

    public BoneAnimation(@Nullable Vec3Animation rotation, @Nullable Vec3Animation position, @Nullable Vec3Animation scale) {
        this.rotation = rotation != null ? rotation : Vec3Animation.ZERO;
        this.position = position != null ? position : Vec3Animation.ZERO;
        this.scale = scale != null ? scale : Vec3Animation.ONE;
    }

    public GeometryTransforms get(Query query) {
        return new GeometryTransforms(this.getTranslation(query), this.getRotation(query), this.getScale(query));
    }

    public GeometryTransforms apply(Query query, BlendMode blending, float weight, GeometryTransforms transforms) {
        if (transforms == null) {
            transforms = GeometryTransforms.createDefault();
        }
        Function3<Vec3, Vec3, Float, Vec3> tf = blending.additiveTransform;
        transforms.translation = (Vec3)tf.apply((Object)transforms.translation, (Object)this.getTranslation(query), (Object)Float.valueOf(weight));
        transforms.rotation = (Vec3)tf.apply((Object)transforms.rotation, (Object)this.getRotation(query), (Object)Float.valueOf(weight));
        transforms.scale = (Vec3)blending.multiplicativeTransform.apply((Object)transforms.scale, (Object)this.getScale(query), (Object)Float.valueOf(weight));
        return transforms;
    }

    public Vec3 getTranslation(Query query) {
        return this.position.get(query);
    }

    public Vec3 getScale(Query query) {
        return this.scale.get(query);
    }

    public Vec3 getRotation(Query query) {
        return this.rotation.get(query);
    }

    public static BoneAnimation parse(AnimationLocation anim, JSONObject bone) {
        if (bone.has("relative_to")) {
            anim.warn("Warning: Detected unsupported feature: relative_to (" + bone.opt("relative_to") + ")! Ignoring.", new Object[0]);
        }
        Vec3Animation rotation = Vec3Animation.parse(bone.opt("rotation"));
        Vec3Animation position = Vec3Animation.parse(bone.opt("position"));
        Vec3Animation scale = Vec3Animation.parse(bone.opt("scale"));
        if (rotation == null && position == null && scale == null) {
            return null;
        }
        return new BoneAnimation(rotation, position, scale);
    }

    public String toString() {
        return "BoneAnimation{rotation=" + this.rotation + ", position=" + this.position + ", scale=" + this.scale + "}";
    }
}

