/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation;

import java.util.function.UnaryOperator;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animsys.ConfiguredAnimation;

public interface IAnimationSource {
    public AnimationLocation getLocation();

    public ConfiguredAnimation configure();

    default public IAnimationSource reconfigure(final UnaryOperator<ConfiguredAnimation> configurator) {
        final IAnimationSource prev = this;
        return new IAnimationSource(){

            @Override
            public AnimationLocation getLocation() {
                return prev.getLocation();
            }

            @Override
            public ConfiguredAnimation configure() {
                return (ConfiguredAnimation)configurator.apply(prev.configure());
            }

            public String toString() {
                return prev + ".reconfigure(" + configurator + ")";
            }
        };
    }
}

