/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.zeith.hammeranims.api.animation.Animation;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.IAnimationContainer;
import org.zeith.hammeranims.api.animation.IAnimationSource;
import org.zeith.hammeranims.api.animsys.ConfiguredAnimation;
import org.zeith.hammeranims.core.init.DefaultsHA;

public class AnimationHolder
implements Supplier<Animation>,
IAnimationSource {
    public final IAnimationContainer container;
    public final String variant;

    public AnimationHolder(IAnimationContainer container, String variant) {
        this.container = container;
        this.variant = variant;
    }

    @Override
    @Nonnull
    public Animation get() {
        Animation animation = this.container.getAnimations().get(this.variant);
        if (animation == null) {
            return DefaultsHA.NULL_ANIMATION_SYNTETIC;
        }
        return animation;
    }

    @Override
    public AnimationLocation getLocation() {
        return new AnimationLocation(this.container.getRegistryKey(), this.variant);
    }

    @Override
    public ConfiguredAnimation configure() {
        return this.get().configure();
    }

    public String toString() {
        return "AnimationHolder{" + this.getLocation() + "}";
    }
}

