/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.animation;

import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.IAnimationContainer;
import org.zeith.hammeranims.api.animation.IAnimationSource;
import org.zeith.hammeranims.api.animation.data.IAnimationData;
import org.zeith.hammeranims.api.animsys.ConfiguredAnimation;
import org.zeith.hammeranims.core.init.DefaultsHA;

public class Animation
implements IAnimationSource {
    protected final IAnimationContainer container;
    protected final String key;
    protected final AnimationLocation location;
    protected final IAnimationData data;

    public Animation(IAnimationContainer container, String key, IAnimationData data) {
        this.container = container;
        this.key = key;
        this.location = new AnimationLocation(container.getRegistryKey(), key);
        this.data = data;
    }

    public IAnimationData getData() {
        return this.data;
    }

    @Override
    public AnimationLocation getLocation() {
        return this.location;
    }

    @Override
    public ConfiguredAnimation configure() {
        return new ConfiguredAnimation(this);
    }

    public boolean isNull() {
        return this == DefaultsHA.NULL_ANIMATION_SYNTETIC;
    }

    public String toString() {
        return "Animation{container=" + this.container + ", key='" + this.key + "', location=" + this.location + ", data=" + this.data + "}";
    }
}

