/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.network.message;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import ttv.migami.jeg.client.network.ClientPlayHandler;
import ttv.migami.jeg.common.CustomGun;
import ttv.migami.jeg.common.CustomGunLoader;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.NetworkGunManager;

public class S2CMessageUpdateGuns
extends PlayMessage<S2CMessageUpdateGuns> {
    private ImmutableMap<ResourceLocation, Gun> registeredGuns;
    private ImmutableMap<ResourceLocation, CustomGun> customGuns;

    public void encode(S2CMessageUpdateGuns message, FriendlyByteBuf buffer) {
        Validate.notNull((Object)((Object)NetworkGunManager.get()));
        Validate.notNull((Object)((Object)CustomGunLoader.get()));
        NetworkGunManager.get().writeRegisteredGuns(buffer);
        CustomGunLoader.get().writeCustomGuns(buffer);
    }

    public S2CMessageUpdateGuns decode(FriendlyByteBuf buffer) {
        S2CMessageUpdateGuns message = new S2CMessageUpdateGuns();
        message.registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
        message.customGuns = CustomGunLoader.readCustomGuns(buffer);
        return message;
    }

    public void handle(S2CMessageUpdateGuns message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleUpdateGuns(message));
        context.setHandled(true);
    }

    public ImmutableMap<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    public ImmutableMap<ResourceLocation, CustomGun> getCustomGuns() {
        return this.customGuns;
    }
}

