/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.client.GunItemStackRenderer;
import ttv.migami.jeg.client.KeyBinds;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.NetworkGunManager;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.debug.Debug;
import ttv.migami.jeg.enchantment.EnchantmentTypes;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModTags;
import ttv.migami.jeg.item.IColored;
import ttv.migami.jeg.item.IMeta;
import ttv.migami.jeg.modifier.Modifier;
import ttv.migami.jeg.modifier.type.IModifierEffect;
import ttv.migami.jeg.modifier.type.StatModifier;
import ttv.migami.jeg.modifier.type.StatType;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class GunItem
extends Item
implements IColored,
IMeta {
    private final WeakHashMap<CompoundTag, Gun> modifiedGunCache = new WeakHashMap();
    private Gun gun = new Gun();
    private Modifier modifier = null;

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public void setGun(NetworkGunManager.Supplier supplier) {
        this.gun = supplier.getGun();
    }

    public Gun getGun() {
        return this.gun;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public static ItemStack makeGunStack(ResourceLocation gunId) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ABSTRACT_GUN.get());
        stack.m_41784_().m_128359_("GunId", gunId.toString());
        return stack;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (this.modifier != null && ((Boolean)Config.COMMON.gameplay.gunModifiers.get()).booleanValue()) {
            pStack.m_41714_((Component)pStack.m_41786_().m_6881_().m_130938_(style -> style.m_178520_(this.modifier.getColor()).m_131155_(Boolean.valueOf(false))));
        }
        if (pStack.m_41783_() != null && !pStack.m_41783_().m_128441_("AmmoCount")) {
            pStack.m_41783_().m_128405_("AmmoCount", 0);
        }
        if (pStack.m_150930_((Item)ModItems.FLARE_GUN.get())) {
            if (pStack.m_41782_() && pStack.m_41783_().m_128471_("HasRaid")) {
                pStack.m_41714_((Component)Component.m_237115_((String)"item.jeg.raid_flare_gun").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131155_(Boolean.valueOf(false))));
            } else if (pStack.m_41786_().equals(Component.m_237115_((String)"item.jeg.raid_flare_gun").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131155_(Boolean.valueOf(false))))) {
                pStack.m_41787_();
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tagCompound = stack.m_41783_();
        Gun modifiedGun = this.getModifiedGun(stack);
        if (stack.m_150930_((Item)ModItems.FLARE_GUN.get())) {
            if (stack.m_41782_() && stack.m_41783_().m_128471_("HasRaid")) {
                String factionName = tagCompound != null && tagCompound.m_128441_("Raid") ? tagCompound.m_128461_("Raid") : "random";
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.raid_flare_gun").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.raid_flare").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.flare_raid").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("faction.jeg." + factionName)).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237113_((String)""));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.flare_gun.color").m_130940_(ChatFormatting.BLUE));
            }
        }
        if (stack.m_41720_() != ModItems.FINGER_GUN.get()) {
            if (Screen.m_96638_()) {
                if (this.modifier != null && ((Boolean)Config.COMMON.gameplay.gunModifiers.get()).booleanValue()) {
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.modifier").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("modifier.jeg." + this.modifier.getName())).m_130938_(style -> style.m_178520_(this.modifier.getColor()))));
                }
                String fireMode = modifiedGun.getGeneral().getFireMode().getId().toString();
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.fire_mode").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("fire_mode." + fireMode)).m_130940_(ChatFormatting.WHITE)));
                Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
                Item reloadItem = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getReloads().getReloadItem());
                if (modifiedGun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
                    ammo = reloadItem;
                }
                if (ammo != null) {
                    tooltip.add((Component)Component.m_237110_((String)"info.jeg.ammo_type", (Object[])new Object[]{Component.m_237115_((String)ammo.m_5524_()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
                }
                Object additionalDamageText = "";
                if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
                    float additionalDamage = tagCompound.m_128457_("AdditionalDamage");
                    if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                        additionalDamageText = ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(additionalDamage);
                    } else if (additionalDamage < 0.0f) {
                        additionalDamageText = ChatFormatting.RED + " " + ItemStack.f_41584_.format(additionalDamage);
                    }
                }
                float damage = modifiedGun.getProjectile().getDamage();
                if (this.modifier != null && ((Boolean)Config.COMMON.gameplay.gunModifiers.get()).booleanValue()) {
                    float fireRateMultiplier = 1.0f;
                    for (IModifierEffect effect : this.modifier.getModifiers()) {
                        StatModifier statModifier;
                        if (!(effect instanceof StatModifier) || (statModifier = (StatModifier)effect).getStatType() != StatType.DAMAGE) continue;
                        fireRateMultiplier = (float)((double)fireRateMultiplier * statModifier.getValue());
                    }
                    damage *= fireRateMultiplier;
                }
                ResourceLocation advantage = modifiedGun.getProjectile().getAdvantage();
                damage = GunModifierHelper.getModifiedProjectileDamage(stack, damage);
                damage = GunEnchantmentHelper.getAcceleratorDamage(stack, damage);
                damage = GunEnchantmentHelper.getWitheredDamage(stack, damage);
                if (modifiedGun.getProjectile().getItem().equals((Object)new ResourceLocation(Items.f_42616_.toString()))) {
                    tooltip.add((Component)Component.m_237110_((String)"info.jeg.damage", (Object[])new Object[]{ChatFormatting.WHITE + ItemStack.f_41584_.format(damage) + (String)additionalDamageText}).m_7220_((Component)Component.m_237113_((String)(" - " + ChatFormatting.WHITE + ItemStack.f_41584_.format((double)(damage * (float)((Integer)Config.COMMON.gameplay.maxResonanceLevel.get()).intValue()) * 0.8) + (String)additionalDamageText))).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"info.jeg.damage", (Object[])new Object[]{ChatFormatting.WHITE + ItemStack.f_41584_.format(damage) + (String)additionalDamageText}).m_130940_(ChatFormatting.GRAY));
                }
                if (modifiedGun.getProjectile().getItem().equals((Object)new ResourceLocation(Items.f_42616_.toString()))) {
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.resonance").m_130940_(ChatFormatting.GREEN));
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.resonance_info").m_130940_(ChatFormatting.GREEN));
                }
                if (!advantage.equals((Object)ModTags.Entities.NONE.f_203868_()) && ((Boolean)Config.COMMON.gameplay.gunAdvantage.get()).booleanValue()) {
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.advantage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("advantage." + advantage)).m_130940_(ChatFormatting.GOLD)));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.shift_tooltip").m_130940_(ChatFormatting.WHITE));
            }
            if (tagCompound != null) {
                if (tagCompound.m_128471_("IgnoreAmmo")) {
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.ignore_ammo").m_130940_(ChatFormatting.AQUA));
                } else {
                    int ammoCount = tagCompound.m_128451_("AmmoCount");
                    tooltip.add((Component)Component.m_237110_((String)"info.jeg.ammo", (Object[])new Object[]{ChatFormatting.WHITE.toString() + ammoCount + "/" + GunModifierHelper.getModifiedAmmoCapacity(stack, modifiedGun)}).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (JustEnoughGuns.devilFruitsLoaded && KeyBinds.KEY_ATTACHMENTS.getKey() == ttv.migami.mdf.client.KeyBinds.KEY_Z_ACTION.getKey()) {
                tooltip.add((Component)Component.m_237110_((String)"info.jeg.attachment_help_mdf", (Object[])new Object[]{KeyBinds.KEY_ATTACHMENTS.m_90863_().getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"info.jeg.attachment_help", (Object[])new Object[]{KeyBinds.KEY_ATTACHMENTS.m_90863_().getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
            }
            if (this == ModItems.TYPHOONEE.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.typhoonee").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.ATLANTEAN_SPEAR.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.atlantean_spear").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.SOULHUNTER_MK2.get() || this == ModItems.HOLLENFIRE_MK2.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.mk2_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.REPEATING_SHOTGUN.get() || this == ModItems.INFANTRY_RIFLE.get() || this == ModItems.SERVICE_RIFLE.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.ww_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.SUBSONIC_RIFLE.get() || this == ModItems.SUPERSONIC_SHOTGUN.get() || this == ModItems.HYPERSONIC_CANNON.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.warden_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.ROCKET_LAUNCHER.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.wither_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.COMPOUND_BOW.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.compound_bow_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.LIGHT_MACHINE_GUN.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.light_machine_gun_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.GRENADE_LAUNCHER.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.grenade_launcher_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.FLAMETHROWER.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.flamethrower_blueprint").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.MINIGUN.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.minigun").m_130940_(ChatFormatting.GRAY));
            } else if (this == ModItems.PRIMITIVE_BOW.get()) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.primitive_bow").m_130940_(ChatFormatting.GRAY));
            }
            if (modifiedGun.getGeneral().getFireTimer() != 0) {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.hold_fire").m_130940_(ChatFormatting.WHITE));
            }
            if (this == ModItems.SUBSONIC_RIFLE.get() || this == ModItems.HYPERSONIC_CANNON.get() || this == ModItems.SUPERSONIC_SHOTGUN.get()) {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.echo_shard").m_130940_(ChatFormatting.WHITE));
            }
            if (this.getEnchantmentLevel(stack, (Enchantment)ModEnchantments.INFINITY.get()) != 0 || this.getEnchantmentLevel(stack, (Enchantment)ModEnchantments.WITHERED.get()) != 0) {
                tooltip.add((Component)Component.m_237113_((String)""));
                if (this.getEnchantmentLevel(stack, (Enchantment)ModEnchantments.WITHERED.get()) != 0) {
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.withered").m_130940_(ChatFormatting.DARK_RED));
                }
                if (this.getEnchantmentLevel(stack, (Enchantment)ModEnchantments.INFINITY.get()) != 0) {
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.infinity").m_130940_(ChatFormatting.AQUA));
                }
            }
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public int m_8105_(ItemStack stack) {
        Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        return gun.getGeneral().getRate() * 4;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41768_();
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        Gun modifiedGun = this.getModifiedGun(stack);
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        if ((double)stack.m_41773_() >= (double)stack.m_41776_() / 1.5) {
            return Objects.requireNonNull(ChatFormatting.RED.m_126665_());
        }
        float stackMaxDamage = this.getMaxDamage(stack);
        float f = Math.max(0.0f, (stackMaxDamage - (float)stack.m_41773_()) / stackMaxDamage);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("GunId")) {
            ResourceLocation gunID = new ResourceLocation(stack.m_41783_().m_128461_("GunId"));
            return Component.m_237115_((String)("item.jeg." + gunID.m_135815_()));
        }
        return super.m_7626_(stack);
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("GunId", 8)) {
            ResourceLocation id = new ResourceLocation(tagCompound.m_128461_("GunId"));
            Gun data = FMLEnvironment.dist.isClient() ? NetworkGunManager.getClientGun(id) : (NetworkGunManager.get() != null ? NetworkGunManager.get().getRegisteredGuns().get(id) : null);
            return data != null ? data : this.gun;
        }
        if (tagCompound != null && tagCompound.m_128425_("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    return Gun.create(tagCompound.m_128469_("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Gun"));
                return gunCopy;
            });
        }
        if (JustEnoughGuns.isDebugging()) {
            return Debug.getGun(this);
        }
        return this.gun;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentTypes.SEMI_AUTO_GUN) {
            Gun modifiedGun = this.getModifiedGun(stack);
            return modifiedGun.getGeneral().getFireMode() != FireMode.AUTOMATIC;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getMaxStackSize(stack) == 1;
    }

    public int m_6473_() {
        return 5;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new GunItemStackRenderer();
            }
        });
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) != 0;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_150930_((Item)ModItems.REPAIR_KIT.get());
    }

    public String getModID() {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)this);
        if (registryName != null) {
            return registryName.m_135827_();
        }
        return null;
    }
}

