/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.init.ModEffects;
import ttv.migami.jeg.item.GunItem;

public class ResonanceProjectileEntity
extends ProjectileEntity {
    public ResonanceProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ResonanceProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack stack, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, stack, item, modifiedGun);
    }

    @Override
    protected void onProjectileTick() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1 && this.f_19797_ < this.life) {
                ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_175830_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 2, 0.1, 0.1, 0.1, 0.05);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int resonanceLevel = 0;
            if (livingEntity.m_21023_((MobEffect)ModEffects.RESONANCE.get()) && (resonanceLevel = livingEntity.m_21124_((MobEffect)ModEffects.RESONANCE.get()).m_19564_() + 1) > (Integer)Config.COMMON.gameplay.maxResonanceLevel.get()) {
                resonanceLevel = (Integer)Config.COMMON.gameplay.maxResonanceLevel.get();
            }
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RESONANCE.get(), 20 + 20 * resonanceLevel, resonanceLevel, false, false));
        }
    }
}

