/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.projectile;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.util.math.ExtendedEntityRayTraceResult;

public class BeamEntity
extends ProjectileEntity {
    private static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    protected float distance = -1.0f;
    protected float laserPitch = 0.0f;
    protected float laserYaw = 0.0f;
    protected short maxTicks = 0;
    protected Vec3 startVec = new Vec3(0.0, 0.0, 0.0);
    protected Vec3 endVec = new Vec3(0.0, 0.0, 0.0);
    public static final EntityDataAccessor<Float> START_X = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> START_Y = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> START_Z = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> END_X = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> END_Y = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> END_Z = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public BeamEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.life = 20;
        this.maxTicks = (short)this.life;
    }

    public BeamEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(START_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(END_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(END_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(END_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DISTANCE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_() instanceof ServerLevel && this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (!this.m_213877_()) {
            this.trace();
        }
    }

    public float getDistance() {
        return ((Float)this.m_20088_().m_135370_(DISTANCE)).floatValue();
    }

    public Vec3 getStartVec() {
        Float x = (Float)this.m_20088_().m_135370_(START_X);
        Float y = (Float)this.m_20088_().m_135370_(START_Y);
        Float z = (Float)this.m_20088_().m_135370_(START_Z);
        return new Vec3((double)x.floatValue(), (double)y.floatValue(), (double)z.floatValue());
    }

    public Vec3 getEndVec() {
        Float x = (Float)this.m_20088_().m_135370_(END_X);
        Float y = (Float)this.m_20088_().m_135370_(END_Y);
        Float z = (Float)this.m_20088_().m_135370_(END_Z);
        return new Vec3((double)x.floatValue(), (double)y.floatValue(), (double)z.floatValue());
    }

    public void trace() {
        Entity entity;
        ProjectileEntity.EntityResult entityResult;
        if (this.shooter == null || this.m_9236_().f_46443_) {
            return;
        }
        Vec3 startVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 endVec = startVec.m_82549_(this.m_20184_());
        Object raytraceresult = BeamEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            endVec = raytraceresult.m_82450_();
        }
        if ((entityResult = this.findEntityOnPath(startVec, endVec)) != null && (entity = ((EntityHitResult)(raytraceresult = new ExtendedEntityRayTraceResult(entityResult))).m_82443_()) instanceof Player) {
            Player player = (Player)entity;
            if (this.shooter instanceof Player && !((Player)this.shooter).m_7099_(player)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null) {
            Vec3 hitVec = raytraceresult.m_82450_();
            this.distance = (float)startVec.m_82554_(hitVec);
        }
        this.laserPitch = this.m_146909_();
        this.laserYaw = this.m_146908_();
        if (this.distance <= 0.0f) {
            this.distance = (float)this.projectile.getSpeed();
        }
        this.startVec = startVec;
        this.endVec = endVec;
        this.f_19804_.m_135381_(START_X, (Object)Float.valueOf((float)startVec.f_82479_));
        this.f_19804_.m_135381_(START_Y, (Object)Float.valueOf((float)startVec.f_82480_));
        this.f_19804_.m_135381_(START_Z, (Object)Float.valueOf((float)startVec.f_82481_));
        this.f_19804_.m_135381_(END_X, (Object)Float.valueOf((float)endVec.f_82479_));
        this.f_19804_.m_135381_(END_Y, (Object)Float.valueOf((float)endVec.f_82480_));
        this.f_19804_.m_135381_(END_Z, (Object)Float.valueOf((float)endVec.f_82481_));
        this.f_19804_.m_135381_(DISTANCE, (Object)Float.valueOf(this.distance));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        CompoundTag start = compound.m_128469_("StartVec");
        this.startVec = this.readVec(start);
        CompoundTag end = compound.m_128469_("EndVec");
        this.endVec = this.readVec(end);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag start = this.saveVec(this.startVec);
        compound.m_128365_("StartVec", (Tag)start);
        CompoundTag end = this.saveVec(this.endVec);
        compound.m_128365_("EndVec", (Tag)end);
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        CompoundTag start = this.saveVec(this.startVec);
        buffer.m_130079_(start);
        CompoundTag end = this.saveVec(this.endVec);
        buffer.m_130079_(end);
        buffer.writeFloat(this.distance);
        buffer.writeFloat(this.laserPitch);
        buffer.writeFloat(this.laserYaw);
        buffer.writeShort((int)this.maxTicks);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        CompoundTag endPos;
        super.readSpawnData(buffer);
        CompoundTag startPos = buffer.m_130260_();
        if (startPos != null) {
            this.startVec = this.readVec(startPos);
        }
        if ((endPos = buffer.m_130260_()) != null) {
            this.endVec = this.readVec(endPos);
        }
        this.distance = buffer.readFloat();
        this.laserPitch = buffer.readFloat();
        this.laserYaw = buffer.readFloat();
        this.maxTicks = buffer.readShort();
    }

    private CompoundTag saveVec(Vec3 vec) {
        CompoundTag start = new CompoundTag();
        start.m_128347_("x", vec.f_82479_);
        start.m_128347_("y", vec.f_82480_);
        start.m_128347_("z", vec.f_82481_);
        return start;
    }

    private Vec3 readVec(CompoundTag tag) {
        double x = tag.m_128459_("x");
        double y = tag.m_128459_("y");
        double z = tag.m_128459_("z");
        return new Vec3(x, y, z);
    }
}

