/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageChargeSync;

public class ChargeTracker {
    private static final Map<UUID, Integer> playerChargeTime = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> playerMaxChargeTime = new HashMap<UUID, Integer>();
    private static final Map<UUID, Float> lastChargeProgress = new HashMap<UUID, Float>();

    public static int getChargeTime(UUID playerId) {
        return playerChargeTime.getOrDefault(playerId, 0);
    }

    public static void updateChargeTime(Player player, ItemStack weapon, boolean isCharging) {
        Item item = weapon.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        UUID playerId = player.m_20148_();
        Gun modifiedGun = gunItem.getModifiedGun(weapon);
        int maxChargeTime = modifiedGun.getGeneral().getMaxHoldFire();
        playerMaxChargeTime.put(playerId, maxChargeTime);
        if (isCharging) {
            int currentCharge = playerChargeTime.getOrDefault(playerId, 0);
            if (++currentCharge > maxChargeTime) {
                currentCharge = maxChargeTime;
            }
            playerChargeTime.put(playerId, currentCharge);
            float progress = maxChargeTime > 0 ? Math.min(1.0f, (float)currentCharge / (float)maxChargeTime) : 0.0f;
            lastChargeProgress.put(playerId, Float.valueOf(progress));
            if (player.m_9236_().m_5776_()) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageChargeSync(progress));
            }
        } else {
            playerChargeTime.remove(playerId);
            lastChargeProgress.remove(playerId);
            if (player.m_9236_().m_5776_()) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageChargeSync(0.0f));
            }
        }
    }

    public static float getChargeProgress(@Nullable Player player, ItemStack weapon) {
        if (player == null || !(weapon.m_41720_() instanceof GunItem)) {
            return 0.0f;
        }
        UUID playerId = player.m_20148_();
        return lastChargeProgress.getOrDefault(playerId, Float.valueOf(0.0f)).floatValue();
    }

    public static void clearLastChargeProgress(UUID playerId) {
        lastChargeProgress.remove(playerId);
    }
}

