/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.framework.network.message.IMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import ttv.migami.jeg.blockentity.BlueprintWorkbenchBlockEntity;
import ttv.migami.jeg.client.screen.CheckBox;
import ttv.migami.jeg.client.util.RecipeHelper;
import ttv.migami.jeg.client.util.RenderUtil;
import ttv.migami.jeg.common.container.BlueprintWorkbenchContainer;
import ttv.migami.jeg.crafting.workbench.BlueprintWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.WorkbenchIngredient;
import ttv.migami.jeg.crafting.workbench.WorkbenchRecipes;
import ttv.migami.jeg.init.ModRecipeTypes;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageCraft;
import ttv.migami.jeg.util.InventoryUtil;

public class BlueprintWorkbenchScreen
extends AbstractContainerScreen<BlueprintWorkbenchContainer> {
    private static final ResourceLocation GUI_BASE = new ResourceLocation("jeg", "textures/gui/workbench.png");
    private static boolean showRemaining = false;
    private final List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private final Inventory playerInventory;
    private final BlueprintWorkbenchBlockEntity workbench;
    private Button btnCraft;
    private CheckBox checkBoxMaterials;
    private ItemStack displayStack;
    private ItemStack oldStack;
    private ItemStack newStack;
    private boolean changed;

    public BlueprintWorkbenchScreen(BlueprintWorkbenchContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.workbench = (BlueprintWorkbenchBlockEntity)container.getWorkbench();
        this.f_97726_ = 275;
        this.f_97727_ = 184;
        this.materials = new ArrayList<MaterialItem>();
        this.createRecipeFromBlueprint();
    }

    private void createRecipeFromBlueprint() {
        ItemStack blueprintStack = this.workbench.m_8020_(0);
        if (!blueprintStack.m_41619_() && blueprintStack.m_41782_() && blueprintStack.m_41783_().m_128441_("Namespace") && blueprintStack.m_41783_().m_128441_("Path")) {
            String gunRecipeId = blueprintStack.m_41783_().m_128461_("Gun");
            NonNullList recipes = WorkbenchRecipes.getAll(this.playerInventory.f_35978_.m_9236_(), (RecipeType)ModRecipeTypes.BLUEPRINT_WORKBENCH.get());
            ResourceLocation itemLocation = new ResourceLocation(blueprintStack.m_41783_().m_128461_("Namespace"), blueprintStack.m_41783_().m_128461_("Path"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            for (BlueprintWorkbenchRecipe recipe : recipes) {
                if (!recipe.m_6423_().toString().equals(gunRecipeId)) continue;
                this.displayStack = item.m_7968_();
                this.loadRecipe(recipe);
                return;
            }
        }
        this.displayStack = ItemStack.f_41583_;
    }

    private void loadRecipe(BlueprintWorkbenchRecipe recipe) {
        this.materials.clear();
        ImmutableList<WorkbenchIngredient> ingredients = recipe.getMaterials();
        if (ingredients != null) {
            for (WorkbenchIngredient ingredient : ingredients) {
                MaterialItem item = new MaterialItem(ingredient);
                item.updateEnabledState();
                this.materials.add(item);
            }
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.btnCraft = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.jeg.workbench.assemble"), button -> {
            BlueprintWorkbenchRecipe recipe = this.getCurrentRecipe();
            if (recipe != null) {
                ResourceLocation registryName = recipe.m_6423_();
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageCraft(registryName, this.workbench.m_58899_()));
            }
        }).m_252794_(this.f_97735_ + 195, this.f_97736_ + 16).m_253046_(74, 20).m_253136_());
        this.btnCraft.f_93623_ = false;
        this.checkBoxMaterials = (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.f_97735_ + 172, this.f_97736_ + 51, (Component)Component.m_237115_((String)"gui.jeg.workbench.show_remaining")));
        this.checkBoxMaterials.setToggled(showRemaining);
    }

    private BlueprintWorkbenchRecipe getCurrentRecipe() {
        ItemStack blueprintStack = this.workbench.m_8020_(0);
        if (!blueprintStack.m_41619_() && blueprintStack.m_41782_()) {
            String namespace = blueprintStack.m_41783_().m_128461_("Namespace");
            String path = blueprintStack.m_41783_().m_128461_("Path");
            return RecipeHelper.getRecipeFromItem(namespace, path, WorkbenchRecipes.getAll(this.playerInventory.f_35978_.m_9236_(), (RecipeType)ModRecipeTypes.BLUEPRINT_WORKBENCH.get()));
        }
        return null;
    }

    public void m_181908_() {
        boolean canCraft;
        super.m_181908_();
        for (MaterialItem material : this.materials) {
            material.tick();
        }
        this.btnCraft.f_93623_ = canCraft = this.materials.stream().allMatch(MaterialItem::isEnabled);
        this.updateItem();
    }

    private void updateItem() {
        if (!this.workbench.m_8020_(0).m_41619_() && this.workbench.m_8020_(0).m_41782_()) {
            String path;
            ItemStack blueprintStack = this.workbench.m_8020_(0);
            String namespace = blueprintStack.m_41783_().m_128461_("Namespace");
            ResourceLocation itemLocation = new ResourceLocation(namespace, path = blueprintStack.m_41783_().m_128461_("Path"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item != Items.f_41852_) {
                this.displayStack = item.m_7968_();
            }
            this.oldStack = this.workbench.m_8020_(0);
            if (this.newStack != this.oldStack) {
                this.loadItem(namespace, path);
            }
        } else {
            this.displayStack = null;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.m_6375_(mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
        return result;
    }

    private void loadItem(String namespace, String path) {
        BlueprintWorkbenchRecipe recipe = RecipeHelper.getRecipeFromItem(namespace, path, WorkbenchRecipes.getAll(this.playerInventory.f_35978_.m_9236_(), (RecipeType)ModRecipeTypes.BLUEPRINT_WORKBENCH.get()));
        this.materials.clear();
        if (recipe != null) {
            ImmutableList<WorkbenchIngredient> ingredients = recipe.getMaterials();
            if (ingredients != null) {
                for (WorkbenchIngredient ingredient : ingredients) {
                    MaterialItem item = new MaterialItem(ingredient);
                    item.updateEnabledState();
                    this.materials.add(item);
                }
            }
            this.newStack = this.oldStack;
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(pGuiGraphics, mouseX, mouseY);
        int startX = this.f_97735_;
        int startY = this.f_97736_;
        if (this.displayStack != null) {
            if (this.filteredMaterials != null && !this.filteredMaterials.isEmpty()) {
                for (int i = 0; i < this.filteredMaterials.size(); ++i) {
                    MaterialItem materialItem;
                    int itemX = startX + 172;
                    int itemY = startY + i * 19 + 63;
                    if (!RenderUtil.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)) == MaterialItem.EMPTY) continue;
                    pGuiGraphics.m_280153_(this.f_96547_, materialItem.getDisplayStack(), mouseX, mouseY);
                    return;
                }
            }
            if (RenderUtil.isMouseWithin(mouseX, mouseY, startX + 8, startY + 38, 160, 48)) {
                pGuiGraphics.m_280153_(this.f_96547_, this.displayStack, mouseX, mouseY);
            }
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 19, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        partialTicks = Minecraft.m_91087_().m_91296_();
        int startX = this.f_97735_;
        int startY = this.f_97736_;
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BASE);
        pGuiGraphics.m_280218_(GUI_BASE, startX, startY, 0, 0, 173, 184);
        pGuiGraphics.m_280411_(GUI_BASE, startX + 173, startY, 78, 184, 173.0f, 0.0f, 1, 184, 256, 256);
        pGuiGraphics.m_280218_(GUI_BASE, startX + 251, startY, 174, 0, 24, 184);
        pGuiGraphics.m_280218_(GUI_BASE, startX + 171, startY + 15, 218, 0, 22, 22);
        if (this.workbench.m_8020_(0).m_41619_()) {
            pGuiGraphics.m_280218_(GUI_BASE, startX + 174, startY + 18, 180, 199, 16, 16);
        }
        if (this.displayStack != null) {
            ItemStack currentItem = this.displayStack;
            StringBuilder builder = new StringBuilder(currentItem.m_41786_().getString());
            if (currentItem.m_41613_() > 1) {
                builder.append(ChatFormatting.GOLD);
                builder.append(ChatFormatting.BOLD);
                builder.append(" x ");
                builder.append(currentItem.m_41613_());
            }
            pGuiGraphics.m_280137_(this.f_96547_, builder.toString(), startX + 88, startY + 22, Color.WHITE.getRGB());
            GL11.glEnable((int)3089);
            RenderUtil.scissor(startX + 8, startY + 17, 160, 70);
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_252880_((float)(startX + 88), (float)(startY + 60), 100.0f);
            modelViewStack.m_85841_(50.0f, -50.0f, 50.0f);
            modelViewStack.m_252781_(Axis.f_252529_.m_252977_(5.0f));
            modelViewStack.m_252781_(Axis.f_252436_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
            RenderSystem.applyModelViewMatrix();
            MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
            Minecraft.m_91087_().m_91291_().m_115143_(currentItem, ItemDisplayContext.FIXED, false, pGuiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, RenderUtil.getModel(currentItem));
            buffer.m_109911_();
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            GL11.glDisable((int)3089);
            this.filteredMaterials = this.getMaterials();
            for (int i = 0; i < this.filteredMaterials.size(); ++i) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BASE);
                MaterialItem materialItem = this.filteredMaterials.get(i);
                ItemStack stack = materialItem.getDisplayStack();
                if (stack.m_41619_()) continue;
                Lighting.m_84930_();
                if (materialItem.isEnabled()) {
                    pGuiGraphics.m_280218_(GUI_BASE, startX + 172, startY + i * 19 + 63, 0, 184, 80, 19);
                } else {
                    pGuiGraphics.m_280218_(GUI_BASE, startX + 172, startY + i * 19 + 63, 0, 222, 80, 19);
                }
                Object name = stack.m_41786_().getString();
                if (this.f_96547_.m_92895_((String)name) > 55) {
                    name = this.f_96547_.m_92834_((String)name, 50).trim() + "...";
                }
                pGuiGraphics.m_280488_(this.f_96547_, (String)name, startX + 172 + 22, startY + i * 19 + 6 + 63, Color.WHITE.getRGB());
                pGuiGraphics.m_280480_(stack, startX + 172 + 2, startY + i * 19 + 1 + 63);
                if (this.checkBoxMaterials.isToggled()) {
                    int count = InventoryUtil.getItemStackAmount((Player)Minecraft.m_91087_().f_91074_, stack);
                    stack = stack.m_41777_();
                    stack.m_41764_(stack.m_41613_() - count);
                }
                pGuiGraphics.m_280370_(this.f_96547_, stack, startX + 172 + 2, startY + i * 19 + 1 + 63);
            }
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.m_122780_((int)6, (Object)MaterialItem.EMPTY);
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : materialItem != MaterialItem.EMPTY).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, (MaterialItem)filteredMaterials.get(i));
        }
        return materials;
    }

    public static class MaterialItem {
        public static final MaterialItem EMPTY = new MaterialItem();
        private long lastTime = System.currentTimeMillis();
        private int displayIndex;
        private boolean enabled = false;
        private WorkbenchIngredient ingredient;
        private final List<ItemStack> displayStacks = new ArrayList<ItemStack>();

        private MaterialItem() {
        }

        private MaterialItem(WorkbenchIngredient ingredient) {
            this.ingredient = ingredient;
            Stream.of(ingredient.m_43908_()).forEach(stack -> {
                ItemStack displayStack = stack.m_41777_();
                displayStack.m_41764_(ingredient.getCount());
                this.displayStacks.add(displayStack);
            });
        }

        public WorkbenchIngredient getIngredient() {
            return this.ingredient;
        }

        public void tick() {
            if (this.ingredient == null) {
                return;
            }
            this.updateEnabledState();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTime >= 1000L) {
                this.displayIndex = (this.displayIndex + 1) % this.displayStacks.size();
                this.lastTime = currentTime;
            }
        }

        public ItemStack getDisplayStack() {
            return this.ingredient != null ? this.displayStacks.get(this.displayIndex) : ItemStack.f_41583_;
        }

        public void updateEnabledState() {
            this.enabled = InventoryUtil.hasWorkstationIngredient((Player)Minecraft.m_91087_().f_91074_, this.ingredient);
        }

        public boolean isEnabled() {
            return this.ingredient == null || this.enabled;
        }
    }
}

