/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.entity.DynamicHelmet;

public class DynamicHelmetRenderer
extends EntityRenderer<DynamicHelmet> {
    private final HumanoidModel<?> defaultModel;

    public DynamicHelmetRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.defaultModel = new HumanoidModel(context.m_174023_(ModelLayers.f_171164_));
    }

    public void render(DynamicHelmet entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light) {
        ArmorItem armorItem;
        ItemStack stack = entity.getStoredStackData();
        Item item = stack.m_41720_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        float rotation = ((float)entity.f_19797_ + partialTick) * 20.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(45.0 + (double)rotation * 0.5)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)((double)rotation * 1.5)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (!(item instanceof ArmorItem)) {
            Minecraft mc = Minecraft.m_91087_();
            ItemRenderer itemRenderer = mc.m_91291_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            itemRenderer.m_269128_(stack, ItemDisplayContext.HEAD, light, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
            poseStack.m_85849_();
        } else if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD) {
            poseStack.m_85841_(1.5f, 1.5f, 1.5f);
            ModelPart model = Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_);
            this.defaultModel.m_5585_().m_104227_(0.0f, -10.0f, 0.0f);
            this.defaultModel.f_102808_.f_104207_ = true;
            this.defaultModel.f_102809_.f_104207_ = true;
            this.defaultModel.f_102810_.f_104207_ = false;
            this.defaultModel.f_102812_.f_104207_ = false;
            this.defaultModel.f_102811_.f_104207_ = false;
            this.defaultModel.f_102814_.f_104207_ = false;
            this.defaultModel.f_102813_.f_104207_ = false;
            ResourceLocation texture = this.getArmorTexture(armorItem);
            if (armorItem.m_40401_() == ArmorMaterials.LEATHER) {
                int color = 10511680;
                CompoundTag display = stack.m_41737_("display");
                if (display != null && display.m_128425_("color", 99)) {
                    color = display.m_128451_("color");
                }
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                this.defaultModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110431_((ResourceLocation)texture)), light, OverlayTexture.f_118083_, r, g, b, 1.0f);
                ResourceLocation overlay = new ResourceLocation("minecraft", "textures/models/armor/leather_layer_1_overlay.png");
                this.defaultModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110431_((ResourceLocation)overlay)), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.defaultModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110431_((ResourceLocation)texture)), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(DynamicHelmet entity) {
        return TextureAtlas.f_118259_;
    }

    private ResourceLocation getArmorTexture(ArmorItem armorItem) {
        String texturePath;
        String namespace;
        String materialName = armorItem.m_40401_().m_6082_();
        String layer = "1";
        if (materialName.contains(":")) {
            String[] parts = materialName.split(":");
            namespace = parts[0];
            texturePath = parts[1];
        } else {
            ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((Object)armorItem);
            namespace = itemKey != null ? itemKey.m_135827_() : "minecraft";
            texturePath = materialName;
        }
        ResourceLocation texture = new ResourceLocation(namespace, "textures/models/armor/" + texturePath + "_layer_" + layer + ".png");
        Minecraft client = Minecraft.m_91087_();
        Optional resource = client.m_91098_().m_213713_(texture);
        if (resource.isPresent()) {
            return texture;
        }
        return new ResourceLocation("minecraft", "textures/models/armor/iron_layer_" + layer + ".png");
    }
}

