/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.network;

import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.BulletTrail;
import ttv.migami.jeg.client.CustomGunManager;
import ttv.migami.jeg.client.audio.GunShotSound;
import ttv.migami.jeg.client.handler.BulletTrailRenderingHandler;
import ttv.migami.jeg.client.handler.GunRenderingHandler;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.NetworkGunManager;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModTags;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.message.S2CMessageBlood;
import ttv.migami.jeg.network.message.S2CMessageBulletTrail;
import ttv.migami.jeg.network.message.S2CMessageExplosiveAmmo;
import ttv.migami.jeg.network.message.S2CMessageGunSound;
import ttv.migami.jeg.network.message.S2CMessageLaser;
import ttv.migami.jeg.network.message.S2CMessageProjectileHitBlock;
import ttv.migami.jeg.network.message.S2CMessageProjectileHitEntity;
import ttv.migami.jeg.network.message.S2CMessageRemoveProjectile;
import ttv.migami.jeg.network.message.S2CMessageSmokeGrenade;
import ttv.migami.jeg.network.message.S2CMessageStunGrenade;
import ttv.migami.jeg.network.message.S2CMessageUpdateGuns;
import ttv.migami.jeg.particles.BulletHoleData;
import ttv.migami.jeg.particles.LaserData;

public class ClientPlayHandler {
    private static final Random RANDOM = new Random();
    private static final AtomicLong lastSoundTime = new AtomicLong(0L);
    private static final long SOUND_COOLDOWN_MS = 50L;

    public static void handleMessageGunSound(S2CMessageGunSound message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (message.showMuzzleFlash()) {
            GunRenderingHandler.get().showMuzzleFlashForPlayer(message.getShooterId());
        }
        if (message.getShooterId() == mc.f_91074_.m_19879_()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(message.getId(), SoundSource.PLAYERS, message.getVolume(), message.getPitch(), mc.f_91073_.m_213780_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new GunShotSound(message.getId(), SoundSource.PLAYERS, message.getX(), message.getY(), message.getZ(), message.getVolume(), message.getPitch(), message.isReload(), mc.f_91073_.m_213780_()));
        }
    }

    public static void handleMessageBlood(S2CMessageBlood message) {
        if (!((Boolean)Config.CLIENT.particle.enableBlood.get()).booleanValue()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                world.m_6493_((ParticleOptions)ModParticleTypes.BLOOD.get(), true, message.getX(), message.getY(), message.getZ(), 0.5, 0.0, 0.5);
            }
        }
    }

    public static void handleExplosiveAmmo(S2CMessageExplosiveAmmo message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            world.m_6493_((ParticleOptions)ModParticleTypes.SMALL_EXPLOSION.get(), true, message.getX(), message.getY(), message.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public static void handleMessageBulletTrail(S2CMessageBulletTrail message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            int[] entityIds = message.getEntityIds();
            Vec3[] positions = message.getPositions();
            Vec3[] motions = message.getMotions();
            ItemStack item = message.getItem();
            int trailColor = message.getTrailColor();
            double trailLengthMultiplier = message.getTrailLengthMultiplier();
            int life = message.getLife();
            double gravity = message.getGravity();
            int shooterId = message.getShooterId();
            boolean enchanted = message.isEnchanted();
            ParticleOptions data = message.getParticleData();
            boolean isVisible = message.isVisible();
            for (int i = 0; i < message.getCount(); ++i) {
                BulletTrailRenderingHandler.get().add(new BulletTrail(entityIds[i], positions[i], motions[i], item, trailColor, trailLengthMultiplier, life, gravity, shooterId, enchanted, data, isVisible));
            }
        }
    }

    public static void handleExplosionStunGrenade(S2CMessageStunGrenade message) {
        int i;
        Minecraft mc = Minecraft.m_91087_();
        ParticleEngine particleManager = mc.f_91061_;
        Level world = (Level)Objects.requireNonNull(mc.f_91073_);
        double x = message.getX();
        double y = message.getY();
        double z = message.getZ();
        for (i = 0; i < 30; ++i) {
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123796_, x, y, z, world.f_46441_, 0.2);
        }
        for (i = 0; i < 30; ++i) {
            Particle smoke = ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123762_, x, y, z, world.f_46441_, 4.0);
            smoke.m_107257_((int)(8.0 / (Math.random() * 0.1 + 0.4) * 0.5));
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123797_, x, y, z, world.f_46441_, 4.0);
        }
    }

    public static void handleExplosionSmokeGrenade(S2CMessageSmokeGrenade message) {
        Minecraft mc = Minecraft.m_91087_();
        Level level = (Level)Objects.requireNonNull(mc.f_91073_);
        double x = message.getX();
        double y = message.getY();
        double z = message.getZ();
        double diameter = (Double)Config.COMMON.smokeGrenades.smokeGrenadeCloudDiameter.get();
        double vel = 0.004;
        int amount = (int)(diameter * 15.0);
        for (int i = 0; i < amount; ++i) {
            level.m_6485_((ParticleOptions)ModParticleTypes.SMOKE_CLOUD.get(), true, x + (Math.random() - 0.5) * diameter, y + Math.random() * (diameter * 0.5), z + (Math.random() - 0.5) * diameter, (Math.random() - 0.5) * vel, Math.random() * (vel * 0.5), (Math.random() - 0.5) * vel);
        }
    }

    private static Particle spawnParticle(ParticleEngine manager, ParticleOptions data, double x, double y, double z, RandomSource rand, double velocityMultiplier) {
        return manager.m_107370_(data, x, y, z, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier);
    }

    public static void handleLaser(S2CMessageLaser message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            double holeX = message.getX() + 0.005 * (double)message.getFace().m_122429_();
            double holeY = message.getY() + 0.005 * (double)message.getFace().m_122430_();
            double holeZ = message.getZ() + 0.005 * (double)message.getFace().m_122431_();
            world.m_6493_((ParticleOptions)new LaserData(message.getFace(), message.getPos()), false, holeX, holeY, holeZ, 0.0, 0.0, 0.0);
            Vec3i normal = message.getFace().m_122436_();
            Vec3 motion = new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_());
            motion.m_82520_(ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_));
        }
    }

    public static void handleProjectileHitBlock(S2CMessageProjectileHitBlock message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            int i;
            BlockState state = world.m_8055_(message.getPos());
            double holeX = message.getX() + 0.005 * (double)message.getFace().m_122429_();
            double holeY = message.getY() + 0.005 * (double)message.getFace().m_122430_();
            double holeZ = message.getZ() + 0.005 * (double)message.getFace().m_122431_();
            double distance = Math.sqrt(mc.f_91074_.m_20275_(message.getX(), message.getY(), message.getZ()));
            world.m_6493_((ParticleOptions)new BulletHoleData(message.getFace(), message.getPos()), false, holeX, holeY, holeZ, 0.0, 0.0, 0.0);
            Vec3i normal = message.getFace().m_122436_();
            Vec3 motion = new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_());
            motion.m_82520_(ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_));
            SoundType soundType = state.m_60827_();
            if (state.m_204336_(ModTags.Blocks.METAL) || soundType.equals(SoundType.f_56743_)) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), (SoundEvent)ModSounds.METAL_HIT.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
                for (i = 0; i < 2; ++i) {
                    world.m_6493_((ParticleOptions)ModParticleTypes.SPARK.get(), false, message.getX(), message.getY(), message.getZ(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
            if (state.m_204336_(ModTags.Blocks.STONE) || soundType.equals(SoundType.f_56742_)) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), (SoundEvent)ModSounds.STONE_HIT.get(), SoundSource.BLOCKS, 0.4f, 1.0f, false);
                world.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, message.getX(), message.getY(), message.getZ(), motion.f_82479_ * (double)RANDOM.nextFloat() / 10.0, motion.f_82480_ * (double)RANDOM.nextFloat() / 10.0, motion.f_82481_ * (double)RANDOM.nextFloat() / 10.0);
                for (i = 0; i < 2; ++i) {
                    world.m_6493_((ParticleOptions)ModParticleTypes.SPARK.get(), false, message.getX(), message.getY(), message.getZ(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
            if (state.m_204336_(BlockTags.f_144280_) || state.m_204336_(ModTags.Blocks.WOOD) || soundType.equals(SoundType.f_56736_)) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), (SoundEvent)ModSounds.WOOD_HIT.get(), SoundSource.BLOCKS, 0.4f, 1.0f, false);
                world.m_6493_((ParticleOptions)ParticleTypes.f_123796_, false, message.getX(), message.getY(), message.getZ(), motion.f_82479_ * (double)RANDOM.nextFloat() / 10.0, motion.f_82480_ * (double)RANDOM.nextFloat() / 10.0, motion.f_82481_ * (double)RANDOM.nextFloat() / 10.0);
            }
            if (state.m_204336_(ModTags.Blocks.SQUISHY)) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), (SoundEvent)ModSounds.SQUISHY_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (Gun.hasAttachmentEquipped(mc.f_91074_.m_21205_(), IAttachment.Type.BARREL) && Gun.getAttachment(IAttachment.Type.BARREL, mc.f_91074_.m_21205_()).m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) {
                world.m_6493_((ParticleOptions)ModParticleTypes.SMALL_EXPLOSION.get(), true, message.getX(), message.getY(), message.getZ(), motion.f_82479_ / 12.0, motion.f_82480_ / 12.0, motion.f_82481_ / 12.0);
            }
            if (distance < (Double)Config.CLIENT.particle.impactParticleDistance.get()) {
                for (i = 0; i < 4; ++i) {
                    motion.m_82520_(ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_));
                    world.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), false, message.getX(), message.getY(), message.getZ(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
            if (distance <= (Double)Config.CLIENT.sounds.impactSoundDistance.get()) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 2.0f, false);
            }
        }
    }

    private static double getRandomDir(RandomSource random) {
        return -0.25 + random.m_188500_() * 0.5;
    }

    public static void handleProjectileHitEntity(S2CMessageProjectileHitEntity message) {
        SoundEvent event;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        if (((Boolean)Config.CLIENT.display.hitmarker.get()).booleanValue()) {
            GunRenderingHandler.get().playHitMarker(message.isCritical() || message.isHeadshot());
        }
        if (message.isHeadshot()) {
            // empty if block
        }
        if ((event = ClientPlayHandler.getHitSound(message.isCritical(), message.isHeadshot(), message.isPlayer())) == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastSoundTime.get() > 50L) {
            lastSoundTime.set(currentTime);
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)1.0f, (float)(1.0f + world.f_46441_.m_188501_() * 0.2f)));
        }
    }

    @Nullable
    private static SoundEvent getHitSound(boolean critical, boolean headshot, boolean player) {
        if (critical) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenCritical.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.criticalSound.get()));
                return event != null ? event : SoundEvents.f_12313_;
            }
        } else if (headshot) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenHeadshot.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.headshotSound.get()));
                return event != null ? event : SoundEvents.f_12314_;
            }
        } else {
            if (player) {
                return SoundEvents.f_12323_;
            }
            if (((Boolean)Config.CLIENT.sounds.playHitMarkerSound.get()).booleanValue()) {
                return (SoundEvent)ModSounds.HIT_MARKER.get();
            }
        }
        return null;
    }

    public static void handleRemoveProjectile(S2CMessageRemoveProjectile message) {
        BulletTrailRenderingHandler.get().remove(message.getEntityId());
    }

    public static void handleUpdateGuns(S2CMessageUpdateGuns message) {
        NetworkGunManager.updateRegisteredGuns(message);
        CustomGunManager.updateCustomGuns(message);
    }
}

