/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BulletTrail {
    private final int entityId;
    private Vec3 position;
    private Vec3 motion;
    private float yaw;
    private float pitch;
    private boolean dead;
    private final ItemStack item;
    private final int trailColor;
    private final double trailLengthMultiplier;
    private int age;
    private final int maxAge;
    private final double gravity;
    private final int shooterId;
    private WeakReference<Entity> shooter;
    private final boolean enchanted;
    private final ParticleOptions particleData;
    private float size;
    private boolean isVisible;

    public BulletTrail(int entityId, Vec3 position, Vec3 motion, ItemStack item, int trailColor, double trailMultiplier, int maxAge, double gravity, int shooterId, boolean enchanted, ParticleOptions particleData, boolean isVisible) {
        this.entityId = entityId;
        this.position = position;
        this.motion = motion;
        this.item = item;
        this.trailColor = trailColor;
        this.trailLengthMultiplier = trailMultiplier;
        this.maxAge = maxAge;
        this.gravity = gravity;
        this.shooterId = shooterId;
        this.enchanted = enchanted;
        this.particleData = particleData;
        this.isVisible = isVisible;
        this.updateYawPitch();
    }

    private void updateYawPitch() {
        float horizontalLength = Mth.m_14116_((float)((float)(this.motion.f_82479_ * this.motion.f_82479_ + this.motion.f_82481_ * this.motion.f_82481_)));
        this.yaw = (float)Math.toDegrees(Mth.m_14136_((double)this.motion.f_82479_, (double)this.motion.f_82481_));
        this.pitch = (float)Math.toDegrees(Mth.m_14136_((double)this.motion.f_82480_, (double)horizontalLength));
    }

    public void tick() {
        Entity entity;
        double distance;
        Entity shooter;
        ++this.age;
        this.position = this.position.m_82549_(this.motion);
        if (this.gravity != 0.0) {
            this.motion = this.motion.m_82520_(0.0, this.gravity, 0.0);
            this.updateYawPitch();
        }
        if ((shooter = this.getShooter()) instanceof Player && ((Player)shooter).m_7578_()) {
            Level world = shooter.m_9236_();
            world.m_6485_((ParticleOptions)ParticleTypes.f_123757_, true, this.position.m_7096_(), this.position.m_7098_(), this.position.m_7094_(), this.motion.f_82479_, this.motion.f_82480_, this.motion.f_82481_);
        }
        double d = distance = (entity = Minecraft.m_91087_().m_91288_()) != null ? Math.sqrt(entity.m_20238_(this.position)) : Double.MAX_VALUE;
        if (this.age >= this.maxAge || distance > 256.0) {
            this.dead = true;
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getMotion() {
        return this.motion;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getAge() {
        return this.age;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getSize() {
        return this.size;
    }

    @Nullable
    public Entity getShooter() {
        Entity entity;
        ClientLevel world;
        if (this.shooter == null && (world = Minecraft.m_91087_().f_91073_) != null && (entity = world.m_6815_(this.shooterId)) != null) {
            this.shooter = new WeakReference<Entity>(entity);
        }
        if (this.shooter != null) {
            Entity entity2 = (Entity)this.shooter.get();
            if (entity2 != null && !entity2.m_6084_()) {
                return null;
            }
            return entity2;
        }
        return null;
    }

    public boolean isTrailVisible() {
        return this.isVisible;
    }

    public int hashCode() {
        return this.entityId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BulletTrail) {
            return ((BulletTrail)obj).entityId == this.entityId;
        }
        return false;
    }
}

