/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class ObjectCache {
    private static final Map<String, ObjectCache> INSTANCES = new HashMap<String, ObjectCache>();
    private final Map<Object, Object> cache = new HashMap<Object, Object>();

    public static ObjectCache getInstance(String key) {
        return INSTANCES.computeIfAbsent(key, s -> new ObjectCache());
    }

    private ObjectCache() {
    }

    public <T> T store(Object key, Supplier<T> supplier) {
        Object cacheValue = this.cache.get(key);
        if (cacheValue != null) {
            return (T)cacheValue;
        }
        T value = supplier.get();
        Objects.requireNonNull(value);
        this.cache.put(key, value);
        return value;
    }

    public <T> Optional<T> get(Object key) {
        return Optional.ofNullable(this.cache.get(key));
    }

    public void reset() {
        this.cache.clear();
    }
}

