/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.animations;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.AnimatedGunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.util.GunEnchantmentHelper;

public final class GunAnimations {
    private static String lastGunId = "";
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation SHOOT = RawAnimation.begin().then("shoot", Animation.LoopType.HOLD_ON_LAST_FRAME);
    public static final RawAnimation AIM_SHOOT = RawAnimation.begin().then("aim_shoot", Animation.LoopType.HOLD_ON_LAST_FRAME);
    public static final RawAnimation HOLD_FIRE = RawAnimation.begin().then("hold_fire", Animation.LoopType.PLAY_ONCE).thenLoop("hold");
    public static final RawAnimation HOLD = RawAnimation.begin().then("hold", Animation.LoopType.LOOP);
    public static final RawAnimation RELOAD = RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    public static final RawAnimation RELOAD_ALT = RawAnimation.begin().then("reload_alt", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    public static final RawAnimation RELOAD_START = RawAnimation.begin().then("reload_start", Animation.LoopType.PLAY_ONCE).thenLoop("reload_loop");
    public static final RawAnimation RELOAD_LOOP = RawAnimation.begin().then("reload_loop", Animation.LoopType.LOOP);
    public static final RawAnimation RELOAD_STOP = RawAnimation.begin().then("reload_stop", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    public static final RawAnimation MELEE = RawAnimation.begin().then("melee", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    public static final RawAnimation BAYONET = RawAnimation.begin().then("bayonet", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    public static final RawAnimation SPRINT = RawAnimation.begin().then("sprint", Animation.LoopType.HOLD_ON_LAST_FRAME);
    public static final RawAnimation INSPECT = RawAnimation.begin().then("inspect", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    public static final RawAnimation DRAW = RawAnimation.begin().then("draw", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    public static final RawAnimation JAM = RawAnimation.begin().then("jam", Animation.LoopType.PLAY_ONCE).thenLoop("idle");

    public static <T extends GeoAnimatable> AnimationController<GeoAnimatable> animationController(AnimatedGunItem animatable) {
        return new AnimationController((GeoAnimatable)animatable, "Controller", 0, state -> {
            String currentId;
            Player player = ClientUtils.getClientPlayer();
            ItemStack gunStack = player.m_21205_();
            if (gunStack.m_41784_().m_128441_("GunId") && !(currentId = gunStack.m_41784_().m_128461_("GunId")).equals(lastGunId)) {
                lastGunId = currentId;
                state.resetCurrentAnimation();
            }
            state.setControllerSpeed(1.0f);
            if (!((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).m_269069_()) {
                return state.setAndContinue(IDLE);
            }
            if (gunStack.m_41720_() != animatable) {
                return state.setAndContinue(IDLE);
            }
            Item patt4146$temp = gunStack.m_41720_();
            if (!(patt4146$temp instanceof AnimatedGunItem)) {
                return state.setAndContinue(IDLE);
            }
            AnimatedGunItem animatedGunItem = (AnimatedGunItem)patt4146$temp;
            if (state.getController().getCurrentAnimation() == null) {
                return state.setAndContinue(IDLE);
            }
            if (gunStack.m_41783_() != null) {
                CompoundTag tag = gunStack.m_41783_();
                if (((Boolean)ModSyncedDataKeys.SHOOTING.getValue((Entity)player)).booleanValue() && animatedGunItem.getModifiedGun(gunStack).getGeneral().getFireMode().equals(FireMode.RELEASE_FIRE)) {
                    return state.setAndContinue(HOLD_FIRE);
                }
                if (tag.m_128471_("IsShooting") || (GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "shoot") || GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "aim_shoot")) && !state.getController().getAnimationState().equals((Object)AnimationController.State.PAUSED)) {
                    state.setControllerSpeed(GunEnchantmentHelper.getReloadAnimationSpeed(gunStack));
                    if (tag.m_128471_("IsAiming")) {
                        return state.setAndContinue(AIM_SHOOT);
                    }
                    return state.setAndContinue(SHOOT);
                }
                if (tag.m_128471_("IsMeleeing") || (GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "melee") || GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "bayonet")) && !state.getController().getAnimationState().equals((Object)AnimationController.State.PAUSED)) {
                    if (Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_()).m_41720_() instanceof SwordItem) {
                        return state.setAndContinue(BAYONET);
                    }
                    return state.setAndContinue(MELEE);
                }
                boolean lacksAmmo = animatedGunItem.getModifiedGun(gunStack).getReloads().getReloadType() == ReloadType.SINGLE_ITEM ? Gun.findAmmo(player, animatedGunItem.getModifiedGun(gunStack).getReloads().getReloadItem()).stack().m_41619_() : Gun.findAmmo(player, animatedGunItem.getModifiedGun(gunStack).getProjectile().getItem()).stack().m_41619_();
                if (!lacksAmmo) {
                    if (!((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue() && GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "reload_loop") || GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "reload_stop")) {
                        state.setControllerSpeed(GunEnchantmentHelper.getReloadAnimationSpeed(gunStack));
                        return state.setAndContinue(RELOAD_STOP);
                    }
                    if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue() || (GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "reload") || GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "reload_alt") || GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "reload_start")) && !state.getController().hasAnimationFinished()) {
                        if (animatedGunItem.getModifiedGun(gunStack).getReloads().getReloadType().equals(ReloadType.MANUAL)) {
                            state.setControllerSpeed(GunEnchantmentHelper.getReloadAnimationSpeed(gunStack));
                            return state.setAndContinue(RELOAD_START);
                        }
                        state.setControllerSpeed(GunEnchantmentHelper.getReloadAnimationSpeed(gunStack));
                        if (gunStack.m_150930_((Item)ModItems.INFANTRY_RIFLE.get()) && (Gun.getAttachment(IAttachment.Type.MAGAZINE, gunStack).m_41720_() == ModItems.EXTENDED_MAG.get() || Gun.getAttachment(IAttachment.Type.MAGAZINE, gunStack).m_41720_() == ModItems.DRUM_MAG.get())) {
                            return state.setAndContinue(RELOAD_ALT);
                        }
                        return state.setAndContinue(RELOAD);
                    }
                }
                if (tag.m_128471_("IsInspecting") || GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "inspect") && !state.getController().hasAnimationFinished()) {
                    if (tag.m_128471_("IsAiming")) {
                        return state.setAndContinue(IDLE);
                    }
                    return state.setAndContinue(INSPECT);
                }
                if (((Boolean)Config.COMMON.gameplay.drawAnimation.get()).booleanValue() && (tag.m_128471_("IsDrawing") || GunAnimations.isAnimationPlaying((AnimationController<GeoAnimatable>)state.getController(), "draw") && !state.getController().hasAnimationFinished() && !AimingHandler.get().isAiming())) {
                    state.setControllerSpeed(GunEnchantmentHelper.getReloadAnimationSpeed(gunStack));
                    return state.setAndContinue(DRAW);
                }
                if (tag.m_128471_("IsRunning") && !tag.m_128471_("IsAiming") && !(Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_()).m_41720_() instanceof SwordItem)) {
                    return state.setAndContinue(SPRINT);
                }
            }
            state.setAndContinue(IDLE);
            return PlayState.CONTINUE;
        });
    }

    public static boolean isAnimationPlaying(AnimationController<GeoAnimatable> animationController, String animation) {
        return animationController.getCurrentAnimation().animation().name().equals(animation);
    }
}

