/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class VexPatch
extends MobPatch<Vex> {
    public VexPatch() {
        super(Factions.ILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((Vex)this.original).f_21345_.m_25352_(0, (Goal)new ChargeAttackGoal());
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        super.selectGoalToRemove(toRemove);
        Iterator iterator = ((Vex)this.original).f_21345_.m_148105_().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            WrappedGoal goal = (WrappedGoal)iterator.next();
            Goal inner = goal.m_26015_();
            if (index == 1) {
                toRemove.add(inner);
                break;
            }
            ++index;
        }
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (!this.isLogicalClient()) {
            if (this.getEntityState().movementLocked()) {
                ((Vex)this.original).f_21345_.m_25355_(Goal.Flag.MOVE);
                ((Vex)this.original).f_21345_.m_25355_(Goal.Flag.JUMP);
            } else {
                ((Vex)this.original).f_21345_.m_25374_(Goal.Flag.MOVE);
                ((Vex)this.original).f_21345_.m_25374_(Goal.Flag.JUMP);
            }
            if (this.getEntityState().turningLocked()) {
                ((Vex)this.original).f_21345_.m_25355_(Goal.Flag.LOOK);
            } else {
                ((Vex)this.original).f_21345_.m_25374_(Goal.Flag.LOOK);
            }
        }
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_IDLE);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.VEX_DEATH);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_FLIPPING);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((Vex)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else {
            this.currentLivingMotion = LivingMotions.IDLE;
            this.currentCompositeMotion = LivingMotions.IDLE;
        }
    }

    @Override
    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
        ((Vex)this.original).m_146884_(((LivingEntity)opponent.getOriginal()).m_146892_().m_82549_(((LivingEntity)opponent.getOriginal()).m_20154_()));
        this.playAnimationSynchronized(Animations.VEX_NEUTRALIZED, 0.0f);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return Animations.VEX_HIT;
    }

    class ChargeAttackGoal
    extends Goal {
        private int chargingCounter;

        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (((Vex)VexPatch.this.original).m_5448_() != null && !VexPatch.this.getEntityState().inaction() && ((Vex)VexPatch.this.original).m_217043_().m_188503_(10) == 0) {
                double distance = ((Vex)VexPatch.this.original).m_20280_((Entity)((Vex)VexPatch.this.original).m_5448_());
                return distance < 49.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.chargingCounter > 0;
        }

        public void m_8056_() {
            ((Vex)VexPatch.this.original).m_21566_().m_6849_(((Vex)VexPatch.this.original).m_20185_(), ((Vex)VexPatch.this.original).m_20186_(), ((Vex)VexPatch.this.original).m_20189_(), 0.25);
            VexPatch.this.playAnimationSynchronized(Animations.VEX_CHARGE, 0.0f);
            ((Vex)VexPatch.this.original).m_5496_(SoundEvents.f_12500_, 1.0f, 1.0f);
            ((Vex)VexPatch.this.original).m_34042_(true);
            this.chargingCounter = 20;
        }

        public void m_8041_() {
            ((Vex)VexPatch.this.original).m_34042_(false);
        }

        public void m_8037_() {
            --this.chargingCounter;
        }
    }
}

