/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.EntityDecorations;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BerserkerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("fdc09ee8-fcfc-11eb-9a03-0242ac130003");
    private float speedBonus;
    private float damageBonus;

    public BerserkerSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.speedBonus = parameters.m_128457_("speed_bonus");
        this.damageBonus = parameters.m_128457_("damage_bonus");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.m_21223_();
            float maxHealth = player.m_21233_();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.01f * this.speedBonus;
            float attackSpeed = event.getAttackSpeed();
            event.setAttackSpeed(Math.min(5.0f, attackSpeed * (1.0f + lostHealthPercentage)));
        });
        listener.addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.m_21223_();
            float maxHealth = player.m_21233_();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.01f * this.damageBonus;
            event.attachValueModifier(ValueModifier.multiplier(1.0f + lostHealthPercentage));
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInitiateClient(final SkillContainer container) {
        final Player player = (Player)container.getExecutor().getOriginal();
        container.getExecutor().getEntityDecorations().addDecorationOverlay(EntityDecorations.BERSERKER_OVERLAY, new EntityDecorations.DecorationOverlay(){

            @Override
            public Vector4f color(float partialTick) {
                float alpha = Mth.m_144920_((float)0.0f, (float)0.42f, (float)(1.0f - player.m_21223_() / player.m_21233_()));
                return new Vector4f(0.66f, 0.06f, 0.07f, alpha);
            }

            @Override
            public boolean shouldRemove() {
                return container.getExecutor().getSkill(BerserkerSkill.this) == null;
            }
        });
        container.getExecutor().getEntityDecorations().addParticleGenerator(EntityDecorations.BERSERKER_PARTICLE, new EntityDecorations.ParticleGenerator(){

            @Override
            public void generateParticles() {
                float healthRatio = player.m_21223_() / player.m_21233_();
                RandomSource random = player.m_217043_();
                float chance = Mth.m_144920_((float)0.0f, (float)0.04f, (float)(1.0f - healthRatio - 0.2f));
                for (int i = 0; i < 4; ++i) {
                    if (!(random.m_188501_() < chance)) continue;
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_() + random.m_188583_() * (double)0.4f, player.m_20186_() + (double)player.m_20206_() * 0.5 + random.m_188583_() * (double)0.6f, player.m_20189_() + random.m_188583_() * (double)0.4f, 0.0, (double)0.2f, 0.0);
                }
            }

            @Override
            public boolean shouldRemove() {
                return container.getExecutor().getSkill(BerserkerSkill.this) == null;
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        Player player = (Player)container.getExecutor().getOriginal();
        float health = player.m_21223_();
        float maxHealth = player.m_21233_();
        return maxHealth - health > 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        Player player = (Player)container.getExecutor().getOriginal();
        float health = player.m_21223_();
        float maxHealth = player.m_21233_();
        float lostHealthPercentage = (maxHealth - health) / maxHealth;
        lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f);
        guiGraphics.drawString(gui.getFont(), String.format("%.0f%%", Float.valueOf(lostHealthPercentage)), x + 4.0f, y + 6.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.1f", Float.valueOf(this.speedBonus)));
        list.add(String.format("%.1f", Float.valueOf(this.damageBonus)));
        return list;
    }
}

