/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.common;

import javax.annotation.Nullable;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.SynchedAnimationVariableKey;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class AnimationVariablePacket<T> {
    protected AssetAccessor<? extends StaticAnimation> animation;
    protected SynchedAnimationVariableKey<T> animationVariableKey;
    protected T value;
    protected Action action;

    public AnimationVariablePacket(SynchedAnimationVariableKey<T> animationVariableKey, @Nullable AssetAccessor<? extends StaticAnimation> animation, T value, Action action) {
        this.animationVariableKey = animationVariableKey;
        this.value = value;
        this.action = action;
        this.animation = animation;
    }

    public void process(LivingEntityPatch<?> entitypatch) {
        switch (this.action) {
            case PUT: {
                if (this.animationVariableKey.isSharedKey()) {
                    ((Animator)entitypatch.getAnimator()).getVariables().putSharedVariable((AnimationVariables.SharedAnimationVariableKey)((Object)this.animationVariableKey), this.value, false);
                    break;
                }
                ((Animator)entitypatch.getAnimator()).getVariables().put((AnimationVariables.IndependentAnimationVariableKey)((Object)this.animationVariableKey), this.animation, this.value, false);
                break;
            }
            case REMOVE: {
                if (this.animationVariableKey.isSharedKey()) {
                    ((Animator)entitypatch.getAnimator()).getVariables().removeSharedVariable((AnimationVariables.SharedAnimationVariableKey)((Object)this.animationVariableKey), false);
                    break;
                }
                ((Animator)entitypatch.getAnimator()).getVariables().remove((AnimationVariables.IndependentAnimationVariableKey)((Object)this.animationVariableKey), this.animation, false);
            }
        }
    }

    public static enum Action {
        PUT,
        REMOVE;

    }
}

