/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import mod.azure.azurelib.event.GeoRenderEvent;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import yesman.epicfight.api.client.model.transformer.AzureModelTransformer;
import yesman.epicfight.api.client.model.transformer.HumanoidModelBaker;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class AzureLibCompat
implements ICompatModule {
    @Override
    public void onModEventBus(IEventBus eventBus) {
    }

    @Override
    public void onForgeEventBus(IEventBus eventBus) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onModEventBusClient(IEventBus eventBus) {
        HumanoidModelBaker.registerNewTransformer(new AzureModelTransformer());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onForgeEventBusClient(IEventBus eventBus) {
        eventBus.addListener(AzureModelTransformer::getGeoArmorTexturePath);
        eventBus.addListener(this::geoEntityRenderPreEvent);
        eventBus.addListener(this::geoEntityRenderPostEvent);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void geoEntityRenderPreEvent(GeoRenderEvent.Entity.Pre event) {
        LivingEntity livingentity;
        RenderEngine renderEngine;
        Entity entity = event.getEntity();
        if (entity.m_9236_() == null) {
            return;
        }
        if (entity instanceof LivingEntity && (renderEngine = ClientEngine.getInstance().renderEngine).hasRendererFor((Entity)(livingentity = (LivingEntity)entity))) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
            LocalPlayerPatch playerpatch = null;
            float originalYRot = 0.0f;
            if ((event.getPartialTick() == 0.0f || event.getPartialTick() == 1.0f) && entitypatch instanceof LocalPlayerPatch) {
                LocalPlayerPatch localPlayerPatch;
                playerpatch = localPlayerPatch = (LocalPlayerPatch)entitypatch;
                originalYRot = playerpatch.getModelYRot();
                playerpatch.setModelYRotInGui(livingentity.m_146908_());
                event.getPoseStack().m_85837_(0.0, 0.1, 0.0);
            }
            if (entitypatch != null && entitypatch.overrideRender()) {
                event.setCanceled(true);
                renderEngine.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                if (ClientEngine.getInstance().getPlayerPatch() != null && !renderEngine.minecraft.f_91066_.f_92062_ && !EpicFightGameRules.DISABLE_ENTITY_UI.getRuleValue(livingentity.m_9236_()).booleanValue()) {
                    for (EntityUI entityIndicator : EntityUI.ENTITY_UI_LIST) {
                        if (!entityIndicator.shouldDraw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPartialTick())) continue;
                        entityIndicator.draw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPoseStack(), event.getBufferSource(), event.getPartialTick());
                    }
                }
            }
            if (playerpatch != null) {
                playerpatch.disableModelYRotInGui(originalYRot);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void geoEntityRenderPostEvent(GeoRenderEvent.Entity.Post event) {
        Entity entity = event.getEntity();
        if (entity.m_9236_() == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            RenderEngine renderEngine = ClientEngine.getInstance().renderEngine;
            if (ClientEngine.getInstance().getPlayerPatch() != null && !renderEngine.minecraft.f_91066_.f_92062_ && !EpicFightGameRules.DISABLE_ENTITY_UI.getRuleValue(livingentity.m_9236_()).booleanValue()) {
                LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                for (EntityUI entityIndicator : EntityUI.ENTITY_UI_LIST) {
                    if (!entityIndicator.shouldDraw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPartialTick())) continue;
                    entityIndicator.draw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPoseStack(), event.getBufferSource(), event.getPartialTick());
                }
            }
        }
    }
}

