/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.gui.ScreenCalculations;
import yesman.epicfight.client.gui.screen.config.UISetupScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.modules.HoldableSkill;

@OnlyIn(value=Dist.CLIENT)
public class BattleModeGui {
    private Minecraft minecraft;
    private int sliding = 29;
    private boolean slidingToggle = false;
    private final List<SkillContainer> skillIcons = new LinkedList<SkillContainer>();

    public BattleModeGui(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void renderTick() {
        if (this.sliding > 50) {
            return;
        }
        if (this.sliding > 0) {
            this.sliding = this.slidingToggle ? (this.sliding -= 2) : (this.sliding += 2);
        }
    }

    public void renderStaminaBar(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (Minecraft.m_91087_().f_91080_ instanceof UISetupScreen) {
            return;
        }
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null) {
            return;
        }
        float maxStamina = playerpatch.getMaxStamina();
        float stamina = playerpatch.getStamina();
        if (maxStamina > 0.0f && stamina < maxStamina) {
            Vec2i pos = ClientConfig.getStaminaPosition(screenWidth, screenHeight);
            float prevStamina = playerpatch.getStaminaO();
            float ratio = (prevStamina + (stamina - prevStamina) * partialTick) / maxStamina;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, (float)this.sliding, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)ratio, (float)0.25f, (float)1.0f);
            guiGraphics.m_280411_(EntityUI.BATTLE_ICON, pos.x, pos.y, 118, 4, 2.0f, 38.0f, 237, 9, 255, 255);
            guiGraphics.m_280411_(EntityUI.BATTLE_ICON, pos.x, pos.y, (int)(118.0f * ratio), 4, 2.0f, 47.0f, (int)(237.0f * ratio), 9, 255, 255);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void renderNormalSkills(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (Minecraft.m_91087_().f_91080_ instanceof UISetupScreen) {
            return;
        }
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null) {
            return;
        }
        for (SkillSlot slot : SkillSlot.ENUM_MANAGER.universalValues()) {
            SkillContainer container;
            if (slot == SkillSlots.WEAPON_INNATE || (container = playerpatch.getSkill(slot)).isEmpty() || this.skillIcons.contains(container) || !container.getSkill().shouldDraw(container)) continue;
            this.skillIcons.add(container);
        }
        this.skillIcons.removeIf(skillContainer -> skillContainer.isEmpty() || !skillContainer.getSkill().shouldDraw((SkillContainer)skillContainer));
        ScreenCalculations.AlignDirection alignDirection = ClientConfig.passiveAlignDirection;
        ScreenCalculations.HorizontalBasis horBasis = ClientConfig.passiveBaseX;
        ScreenCalculations.VerticalBasis verBasis = ClientConfig.passiveBaseY;
        int passiveX = horBasis.positionGetter.apply(screenWidth, ClientConfig.passiveX);
        int passiveY = verBasis.positionGetter.apply(screenHeight, ClientConfig.passiveY);
        int icons = this.skillIcons.size();
        Vec2i slotCoord = alignDirection.startCoordGetter.get(passiveX, passiveY, 24, 24, icons, horBasis, verBasis);
        for (SkillContainer container : this.skillIcons) {
            if (container.isEmpty()) continue;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            container.getSkill().drawOnGui(this, container, guiGraphics, slotCoord.x, slotCoord.y, partialTick);
            slotCoord = alignDirection.nextPositionGetter.getNext(horBasis, verBasis, slotCoord, 24, 24);
        }
    }

    public void renderWeaponInnateSkill(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (Minecraft.m_91087_().f_91080_ instanceof UISetupScreen) {
            return;
        }
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null) {
            return;
        }
        SkillContainer container = playerpatch.getSkill(SkillSlots.WEAPON_INNATE);
        if (!container.isEmpty() && container.getSkill().shouldDraw(container)) {
            Window sr = Minecraft.m_91087_().m_91268_();
            int width = sr.m_85445_();
            int height = sr.m_85446_();
            Vec2i pos = ClientConfig.getWeaponInnatePosition(width, height);
            container.getSkill().drawOnGui(this, container, guiGraphics, pos.x, pos.y, partialTick);
        }
    }

    public void renderCharingBar(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        HoldableSkill holdableSkill;
        if (Minecraft.m_91087_().f_91080_ instanceof UISetupScreen) {
            return;
        }
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null) {
            return;
        }
        if (playerpatch.isHoldingAny() && (holdableSkill = playerpatch.getHoldingSkill()) instanceof ChargeableSkill) {
            ChargeableSkill chargeableSkill = (ChargeableSkill)holdableSkill;
            int chargeAmount = playerpatch.getChargingAmount();
            int prevChargingAmount = playerpatch.getPrevChargingAmount();
            float ratio = Math.min(((float)prevChargingAmount + (float)(chargeAmount - prevChargingAmount) * partialTick) / (float)chargeableSkill.getMaxChargingTicks(), 1.0f);
            Vec2i pos = ClientConfig.getChargingBarPosition(screenWidth, screenHeight);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, (float)this.sliding, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(EntityUI.BATTLE_ICON, pos.x, pos.y, 1.0f, 71.0f, 238, 13, 255, 255);
            guiGraphics.m_280163_(EntityUI.BATTLE_ICON, pos.x, pos.y, 1.0f, 57.0f, (int)(238.0f * ratio), 13, 255, 255);
            ResourceLocation rl = ResourceLocation.parse((String)chargeableSkill.toString());
            String skillName = Component.m_237115_((String)String.format("skill.%s.%s", rl.m_135827_(), rl.m_135815_())).getString();
            int stringWidth = this.minecraft.f_91062_.m_92895_(skillName);
            guiGraphics.drawString(this.minecraft.f_91062_, skillName, (float)(pos.x + 120) - (float)stringWidth * 0.5f, (float)(pos.y - 12), 0xFFFFFF, true);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void slideUp() {
        this.sliding = 49;
        this.slidingToggle = true;
    }

    public void slideDown() {
        this.sliding = 1;
        this.slidingToggle = false;
    }

    public void init() {
        this.skillIcons.clear();
    }

    public int getSlidingProgression() {
        return this.sliding;
    }

    public Font getFont() {
        return this.minecraft.f_91062_;
    }
}

