/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.client.input.PlayerInputState;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.handlers.InputManager;
import yesman.epicfight.api.utils.FakeLevel;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@OnlyIn(value=Dist.CLIENT)
public class ControlEngine {
    private final Set<Object> packets = Sets.newHashSet();
    private final Minecraft minecraft;
    private LocalPlayer player;
    private LocalPlayerPatch playerPatch;
    private int weaponInnatePressCounter = 0;
    private int sneakPressCounter = 0;
    private int moverPressCounter = 0;
    private int tickSinceLastJump = 0;
    private int lastHotbarLockedTime;
    private boolean weaponInnatePressToggle = false;
    private boolean sneakPressToggle = false;
    private boolean moverPressToggle = false;
    private boolean attackLightPressToggle = false;
    private boolean hotbarLocked;
    private boolean holdingFinished;
    private int reserveCounter;
    @Deprecated
    private KeyMapping reservedKey;
    private SkillSlot reservedOrHoldingSkillSlot;
    @Deprecated
    private KeyMapping currentHoldingKey;
    public Options options;

    public ControlEngine() {
        Events.controlEngine = this;
        this.minecraft = Minecraft.m_91087_();
        this.options = this.minecraft.f_91066_;
    }

    public void setPlayerPatch(LocalPlayerPatch playerPatch) {
        this.weaponInnatePressCounter = 0;
        this.weaponInnatePressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.attackLightPressToggle = false;
        this.player = (LocalPlayer)playerPatch.getOriginal();
        this.playerPatch = playerPatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerPatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.m_245714_() != null;
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.m_245714_() != null;
    }

    public void handleEpicFightKeyMappings() {
        SkillContainer container;
        if (this.playerPatch == null) {
            return;
        }
        InputManager.triggerOnPress(EpicFightInputActions.OPEN_SKILL_SCREEN, false, this::openSkillEditor);
        InputManager.triggerOnPress(EpicFightInputActions.OPEN_CONFIG_SCREEN, false, this::openConfig);
        InputManager.triggerOnPress(EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING, false, this::switchVanillaModelDebugging);
        InputManager.triggerOnPress(EpicFightInputActions.ATTACK, true, this::maybeAttack);
        InputManager.triggerOnPress(EpicFightInputActions.DODGE, true, this::maybeDodge);
        if (InputManager.isActionActive(EpicFightInputActions.GUARD)) {
            this.maybeGuard();
        }
        InputManager.triggerOnPress(EpicFightInputActions.WEAPON_INNATE_SKILL, true, this::handleSeparateWeaponInnateSkill);
        InputManager.triggerOnPress(EpicFightInputActions.MOBILITY, true, this::maybePerformMoverSkill);
        InputManager.triggerOnPress(EpicFightInputActions.SWITCH_MODE, false, this::switchMode);
        InputManager.triggerOnPress(EpicFightInputActions.LOCK_ON, false, this.playerPatch::toggleLockOn);
        if (ControlEngine.shouldDisableSwapHandItems()) {
            ControlEngine.consumeSwapOffhandKeyClicks();
        }
        if (!this.playerPatch.isEpicFightMode() || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (this.player.f_19797_ - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.weaponInnatePressToggle) {
            if (!InputManager.isActionActive(EpicFightInputActions.WEAPON_INNATE_SKILL)) {
                this.attackLightPressToggle = true;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.WEAPON_INNATE_SKILL, EpicFightInputActions.ATTACK)) {
                if (this.weaponInnatePressCounter > ClientConfig.longPressCounter) {
                    if (this.playerPatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerPatch, this).shouldReserveKey()) {
                        if (!this.player.m_5833_()) {
                            this.reserveKey((SkillSlot)SkillSlots.WEAPON_INNATE, EpicFightInputActions.WEAPON_INNATE_SKILL);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.weaponInnatePressToggle = false;
                    this.weaponInnatePressCounter = 0;
                } else {
                    ++this.weaponInnatePressCounter;
                }
            }
        }
        if (this.attackLightPressToggle) {
            SkillContainer airSlash = this.playerPatch.getSkill(SkillSlots.AIR_ATTACK);
            SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
            SkillCastEvent skillCastEvent = this.playerPatch.getSkill(slot).sendCastRequest(this.playerPatch, this);
            if (skillCastEvent.isExecutable()) {
                this.player.m_36334_();
                this.releaseAllServedKeys();
            } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                this.reserveKey((SkillSlot)slot, EpicFightInputActions.ATTACK);
            }
            this.lockHotkeys();
            this.attackLightPressToggle = false;
            this.weaponInnatePressToggle = false;
            this.weaponInnatePressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!InputManager.isActionActive(EpicFightInputActions.SNEAK)) {
                SkillSlots skillSlot = this.playerPatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                SkillContainer skill = this.playerPatch.getSkill(skillSlot);
                if (skill.sendCastRequest(this.playerPatch, this).shouldReserveKey()) {
                    this.reserveKey((SkillSlot)skillSlot, EpicFightInputActions.SNEAK);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > ClientConfig.longPressCounter) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.currentHoldingKey != null && !(container = this.playerPatch.getSkill(this.reservedOrHoldingSkillSlot)).isEmpty()) {
            if (container.getSkill() instanceof HoldableSkill) {
                Skill skill;
                if (!this.isCurrentHoldingActionActive()) {
                    this.holdingFinished = true;
                }
                if ((skill = container.getSkill()) instanceof ChargeableSkill) {
                    ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill);
                    if (this.holdingFinished) {
                        if (this.playerPatch.getSkillChargingTicks() > chargingSkill.getMinChargingTicks()) {
                            container.sendCastRequest(this.playerPatch, this);
                            this.releaseAllServedKeys();
                        }
                    } else if (this.playerPatch.getSkillChargingTicks() >= chargingSkill.getAllowedMaxChargingTicks()) {
                        this.releaseAllServedKeys();
                    }
                } else if (this.holdingFinished) {
                    this.playerPatch.resetHolding();
                    container.getSkill().cancelOnClient(container, container.getSkill().gatherArguments(container, this));
                    container.sendCancelRequest(this.playerPatch, this);
                    this.releaseAllServedKeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.reservedKey != null) {
            if (this.reserveCounter > 0) {
                SkillContainer skill = this.playerPatch.getSkill(this.reservedOrHoldingSkillSlot);
                --this.reserveCounter;
                if (skill.getSkill() != null && skill.sendCastRequest(this.playerPatch, this).isExecutable()) {
                    this.releaseAllServedKeys();
                    this.lockHotkeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.isSwitchOrDropBlocked()) {
            ControlEngine.disableHotbarSlotPresses();
            ControlEngine.consumeDropKeyClicks();
        }
    }

    private void openSkillEditor() {
        CapabilitySkill capabilitySkill = this.playerPatch.getSkillCapability();
        if (capabilitySkill == null) {
            return;
        }
        this.minecraft.m_91152_((Screen)new SkillEditScreen((Player)this.player, capabilitySkill));
    }

    private void openConfig() {
        this.minecraft.m_91152_((Screen)new IngameConfigurationScreen(null));
    }

    private void switchVanillaModelDebugging() {
        boolean flag = ClientEngine.getInstance().switchVanillaModelDebuggingMode();
        this.minecraft.f_91068_.m_90913_(flag ? "debug.vanilla_model_debugging.on" : "debug.vanilla_model_debugging.off", new Object[0]);
    }

    private void maybeAttack() {
        if (!this.playerPatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.ATTACK)) {
            return;
        }
        EpicFightInputActions vanillaAttack = EpicFightInputActions.VANILLA_ATTACK_DESTROY;
        EpicFightInputActions epicFightAttack = EpicFightInputActions.ATTACK;
        boolean shouldPlayAttackAnimation = this.playerPatch.canPlayAttackAnimation();
        if (vanillaAttack.keyMapping().getKey() == epicFightAttack.keyMapping().getKey() && Minecraft.m_91087_().f_91077_ != null && shouldPlayAttackAnimation) {
            ControlEngine.consumeVanillaAttackKeyClicks();
        }
        if (shouldPlayAttackAnimation) {
            if (!InputManager.isBoundToSamePhysicalInput(epicFightAttack, EpicFightInputActions.WEAPON_INNATE_SKILL)) {
                SkillContainer airSlash = this.playerPatch.getSkill(SkillSlots.AIR_ATTACK);
                SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
                SkillCastEvent skillCastEvent = this.playerPatch.getSkill(slot).sendCastRequest(this.playerPatch, this);
                if (skillCastEvent.isExecutable()) {
                    this.player.m_36334_();
                    this.attackLightPressToggle = false;
                    this.releaseAllServedKeys();
                } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                    this.reserveKey((SkillSlot)slot, epicFightAttack);
                }
                this.lockHotkeys();
                this.attackLightPressToggle = false;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (!this.weaponInnatePressToggle) {
                this.weaponInnatePressToggle = true;
            }
        }
    }

    private void maybeDodge() {
        if (!this.playerPatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.DODGE)) {
            return;
        }
        if (InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.DODGE, EpicFightInputActions.SNEAK)) {
            if (this.player.m_20202_() == null && !this.sneakPressToggle) {
                this.sneakPressToggle = true;
            }
        } else {
            SkillSlots skillCategory = this.playerPatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
            SkillContainer skill = this.playerPatch.getSkill(skillCategory);
            if (!skill.isEmpty() && skill.sendCastRequest(this.playerPatch, this).shouldReserveKey()) {
                this.reserveKey((SkillSlot)SkillSlots.DODGE, EpicFightInputActions.DODGE);
            }
        }
    }

    private void maybeGuard() {
        if (!this.playerPatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.GUARD)) {
            return;
        }
        boolean shouldCancelGuard = false;
        if (this.playerPatch.isHoldingAny()) {
            shouldCancelGuard = true;
        } else if (ShieldItem.class.isAssignableFrom(this.player.m_21205_().m_41720_().getClass()) || ShieldItem.class.isAssignableFrom(this.player.m_21206_().m_41720_().getClass())) {
            shouldCancelGuard = true;
        }
        if (!shouldCancelGuard) {
            SkillCastEvent skillCastEvent = this.playerPatch.getSkill(SkillSlots.GUARD).sendCastRequest(this.playerPatch, this);
            if (skillCastEvent.shouldReserveKey()) {
                if (!this.player.m_5833_()) {
                    this.reserveKey((SkillSlot)SkillSlots.GUARD, EpicFightInputActions.GUARD);
                }
            } else {
                this.lockHotkeys();
            }
        }
    }

    private void handleSeparateWeaponInnateSkill() {
        if (!this.playerPatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.WEAPON_INNATE_SKILL)) {
            return;
        }
        if (!InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.ATTACK, EpicFightInputActions.WEAPON_INNATE_SKILL)) {
            if (this.playerPatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerPatch, this).shouldReserveKey()) {
                if (!this.player.m_5833_()) {
                    this.reserveKey((SkillSlot)SkillSlots.WEAPON_INNATE, EpicFightInputActions.WEAPON_INNATE_SKILL);
                }
            } else {
                this.lockHotkeys();
            }
        }
    }

    private void maybePerformMoverSkill() {
        if (!this.playerPatch.isEpicFightMode() || this.playerPatch.isHoldingAny()) {
            return;
        }
        if (InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.MOBILITY, EpicFightInputActions.JUMP)) {
            SkillCastEvent event;
            SkillContainer skillContainer = this.playerPatch.getSkill(SkillSlots.MOVER);
            if (!skillContainer.isEmpty() && skillContainer.canUse(this.playerPatch, event = new SkillCastEvent(this.playerPatch, skillContainer, skillContainer.getSkill().gatherArguments(skillContainer, this))) && this.player.m_20202_() == null && !this.moverPressToggle) {
                this.moverPressToggle = true;
            }
        } else {
            SkillContainer skill = this.playerPatch.getSkill(SkillSlots.MOVER);
            skill.sendCastRequest(this.playerPatch, this);
        }
    }

    private void switchMode() {
        boolean canSwitch = EpicFightGameRules.CAN_SWITCH_PLAYER_MODE.getRuleValue(((LocalPlayer)this.playerPatch.getOriginal()).m_9236_());
        if (!canSwitch) {
            this.minecraft.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"epicfight.messages.mode_switching_disabled").m_130940_(ChatFormatting.RED));
            return;
        }
        this.playerPatch.toggleMode();
    }

    private void inputTick(Input input) {
        PlayerInputState inputState = InputManager.getInputState(input);
        if (this.moverPressToggle) {
            if (!InputManager.isActionActive(EpicFightInputActions.JUMP)) {
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
                if (this.player.m_20096_()) {
                    this.player.f_20954_ = 0;
                    inputState = inputState.withJumping(true);
                    InputManager.setInputState(inputState);
                }
            } else if (this.moverPressCounter > ClientConfig.longPressCounter) {
                SkillContainer skill = this.playerPatch.getSkill(SkillSlots.MOVER);
                skill.sendCastRequest(this.playerPatch, this);
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
            } else {
                this.player.f_20954_ = 2;
                ++this.moverPressCounter;
            }
        }
        if (!this.canPlayerMove(this.playerPatch.getEntityState())) {
            inputState = inputState.copyWith(Float.valueOf(0.0f), Float.valueOf(0.0f), false, false, false, false, false, false);
            InputManager.setInputState(inputState);
            this.player.f_108583_ = -1;
            this.player.m_6858_(false);
        }
        if (this.player.m_6084_()) {
            this.playerPatch.getEventListener().triggerEvents(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, new MovementInputEvent(this.playerPatch, inputState));
        }
        if (this.tickSinceLastJump > 0) {
            --this.tickSinceLastJump;
        }
    }

    @Deprecated(forRemoval=true)
    private void reserveKey(SkillSlot slot, KeyMapping keyMapping) {
        this.reservedKey = keyMapping;
        this.reservedOrHoldingSkillSlot = slot;
        this.reserveCounter = 8;
    }

    private void reserveKey(SkillSlot slot, EpicFightInputActions action) {
        this.reserveKey(slot, action.keyMapping());
    }

    public void releaseAllServedKeys() {
        this.holdingFinished = true;
        this.currentHoldingKey = null;
        this.reservedOrHoldingSkillSlot = null;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void setHoldingKey(SkillSlot chargingSkillSlot, KeyMapping keyMapping) {
        this.holdingFinished = false;
        this.currentHoldingKey = keyMapping;
        this.reservedOrHoldingSkillSlot = chargingSkillSlot;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.f_19797_;
        ControlEngine.disableHotbarSlotPresses();
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    public void addPacketToSend(Object packet) {
        this.packets.add(packet);
    }

    @Deprecated(forRemoval=true)
    public static boolean isKeyDown(KeyMapping key) {
        if (key.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return key.m_90857_() || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        if (key.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return key.m_90857_() || GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    private static boolean isKeyPressed(KeyMapping key, boolean eventCheck) {
        int mouseButton;
        InputEvent.InteractionKeyMappingTriggered inputEvent;
        boolean consumes = key.m_90859_();
        if (consumes && eventCheck && (inputEvent = ForgeHooksClient.onClickInput((int)(mouseButton = InputConstants.Type.MOUSE == key.getKey().m_84868_() ? key.getKey().m_84873_() : -1), (KeyMapping)key, (InteractionHand)InteractionHand.MAIN_HAND)).isCanceled()) {
            return false;
        }
        return consumes;
    }

    @Deprecated(forRemoval=false)
    public static void makeUnpressed(KeyMapping keyMapping) {
        while (keyMapping.m_90859_()) {
        }
        KeyMapping.m_90837_((InputConstants.Key)keyMapping.getKey(), (boolean)false);
    }

    @Deprecated(forRemoval=true)
    public static void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    public static void setSprintingKeyStateNotDown() {
        KeyMapping.m_90837_((InputConstants.Key)EpicFightInputActions.SPRINT.keyMapping().getKey(), (boolean)false);
    }

    @ApiStatus.Internal
    public static boolean shouldDisableVanillaAttack() {
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch == null) {
            return false;
        }
        return playerPatch.isEpicFightMode() && playerPatch.canPlayAttackAnimation();
    }

    @ApiStatus.Internal
    public static boolean shouldDisableSwapHandItems() {
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch == null) {
            return false;
        }
        return playerPatch.getEntityState().inaction() || !playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand();
    }

    private static void consumeVanillaAttackKeyClicks() {
        ControlEngine.makeUnpressed(EpicFightInputActions.VANILLA_ATTACK_DESTROY.keyMapping());
    }

    private static void consumeSwapOffhandKeyClicks() {
        ControlEngine.makeUnpressed(EpicFightInputActions.SWAP_OFF_HAND.keyMapping());
    }

    private static void disableHotbarSlotPresses() {
        KeyMapping[] hotbarSlots = Minecraft.m_91087_().f_91066_.f_92056_;
        for (int i = 0; i < 9; ++i) {
            KeyMapping hotbarSlot = hotbarSlots[i];
            ControlEngine.makeUnpressed(hotbarSlot);
        }
    }

    private static void consumeDropKeyClicks() {
        ControlEngine.makeUnpressed(EpicFightInputActions.DROP.keyMapping());
    }

    @Nullable
    private static EpicFightInputActions mapKeyMappingToAction(@NotNull KeyMapping keyMapping) {
        return EpicFightInputActions.fromKeyMapping(keyMapping);
    }

    private boolean isCurrentHoldingAction(@NotNull EpicFightInputActions other) {
        if (this.currentHoldingKey == null) {
            return false;
        }
        EpicFightInputActions currentHoldingAction = ControlEngine.mapKeyMappingToAction(this.currentHoldingKey);
        if (currentHoldingAction == null) {
            return this.currentHoldingKey == other.keyMapping();
        }
        return other == currentHoldingAction;
    }

    private boolean isCurrentHoldingActionActive() {
        if (this.currentHoldingKey == null) {
            return false;
        }
        EpicFightInputActions currentHoldingAction = ControlEngine.mapKeyMappingToAction(this.currentHoldingKey);
        if (currentHoldingAction == null) {
            return ControlEngine.isKeyDown(this.currentHoldingKey);
        }
        return InputManager.isActionActive(currentHoldingAction);
    }

    @ApiStatus.Internal
    public static boolean isHotbarCyclingDisabled() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        return minecraft.f_91074_ != null && localPlayerPatch != null && !localPlayerPatch.getEntityState().canSwitchHoldingItem() && minecraft.f_91080_ == null;
    }

    public boolean isSwitchOrDropBlocked() {
        return !this.playerPatch.getEntityState().canSwitchHoldingItem() || this.hotbarLocked;
    }

    public boolean moverToggling() {
        return this.moverPressToggle;
    }

    public boolean sneakToggling() {
        return this.sneakPressToggle;
    }

    public boolean attackToggling() {
        return this.attackLightPressToggle;
    }

    public boolean weaponInnateToggling() {
        return this.weaponInnatePressToggle;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControlEngine controlEngine;

        @SubscribeEvent
        public static void livingJumpEvent(LivingEvent.LivingJumpEvent event) {
            if (event.getEntity() == Events.controlEngine.player) {
                Events.controlEngine.tickSinceLastJump = 5;
            }
        }

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollingEvent event) {
            if (ControlEngine.isHotbarCyclingDisabled()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(MovementInputUpdateEvent event) {
            if (Events.controlEngine.playerPatch == null) {
                return;
            }
            controlEngine.inputTick(event.getInput());
        }

        @SubscribeEvent
        public static void clientTickEndEvent(TickEvent.ClientTickEvent event) {
            if (Events.controlEngine.minecraft.f_91074_ == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                for (Object packet : Events.controlEngine.packets) {
                    EpicFightNetworkManager.sendToServer(packet);
                }
                Events.controlEngine.packets.clear();
            }
        }

        @SubscribeEvent
        public static void interactionEvent(InputEvent.InteractionKeyMappingTriggered event) {
            if (Events.controlEngine.minecraft.f_91074_ == null || Events.controlEngine.minecraft.f_91077_ == null) {
                return;
            }
            EpicFightInputActions triggeredAction = ControlEngine.mapKeyMappingToAction(event.getKeyMapping());
            if (triggeredAction == null) {
                return;
            }
            if (triggeredAction == EpicFightInputActions.VANILLA_ATTACK_DESTROY && InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.ATTACK, EpicFightInputActions.VANILLA_ATTACK_DESTROY) && Events.controlEngine.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && ClientConfig.combatPreferredItems.contains(Events.controlEngine.player.m_21205_().m_41720_())) {
                BlockPos bp = ((BlockHitResult)Events.controlEngine.minecraft.f_91077_).m_82425_();
                BlockState bs = Events.controlEngine.minecraft.f_91073_.m_8055_(bp);
                if (!Events.controlEngine.player.m_21205_().m_41720_().m_6777_(bs, Events.controlEngine.player.m_9236_(), bp, (Player)Events.controlEngine.player) || Events.controlEngine.player.m_21205_().m_41691_(bs) <= 1.0f) {
                    event.setSwingHand(false);
                    event.setCanceled(true);
                }
            }
            if (triggeredAction == EpicFightInputActions.USE && InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.USE, EpicFightInputActions.GUARD)) {
                MutableBoolean canGuard = new MutableBoolean(false);
                MutableBoolean vanillaMode = new MutableBoolean(false);
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)Events.controlEngine.minecraft.f_91074_, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                    SkillContainer skillcontainer = playerpatch.getSkill(SkillSlots.GUARD);
                    if (playerpatch.getPlayerMode() == PlayerPatch.PlayerMode.VANILLA) {
                        vanillaMode.setTrue();
                    }
                    if (skillcontainer.getSkill() != null && skillcontainer.getSkill().canExecute(skillcontainer)) {
                        canGuard.setValue(true);
                    }
                });
                if (!vanillaMode.getValue().booleanValue()) {
                    if (Events.controlEngine.minecraft.f_91077_.m_6662_() == HitResult.Type.MISS) {
                        if (canGuard.booleanValue() && ClientConfig.keyConflictResolveScope.cancelItemUse()) {
                            event.setSwingHand(false);
                            event.setCanceled(true);
                        }
                    } else if (canGuard.booleanValue()) {
                        InteractionResult interactionResult = switch (Events.controlEngine.minecraft.f_91077_.m_6662_()) {
                            case HitResult.Type.ENTITY -> ((EntityHitResult)Events.controlEngine.minecraft.f_91077_).m_82443_().m_6096_((Player)Events.controlEngine.minecraft.f_91074_, event.getHand());
                            case HitResult.Type.BLOCK -> {
                                BlockHitResult blockHitResult = (BlockHitResult)Events.controlEngine.minecraft.f_91077_;
                                BlockPos blockpos = blockHitResult.m_82425_();
                                BlockState blockstate = Events.controlEngine.minecraft.f_91073_.m_8055_(blockpos);
                                FakeLevel fakeLevelForSimulation = FakeLevel.getFakeLevel(Events.controlEngine.minecraft.f_91073_);
                                FakeLevel.FakeClientPlayer fakePlayerForSimulation = FakeLevel.getFakePlayer(Events.controlEngine.minecraft.f_91074_.m_36316_());
                                yield blockstate.m_60664_((Level)fakeLevelForSimulation, (Player)fakePlayerForSimulation, event.getHand(), blockHitResult);
                            }
                            default -> throw new IllegalArgumentException();
                        };
                        if (interactionResult != InteractionResult.PASS && ClientConfig.keyConflictResolveScope.cancelInteraction()) {
                            event.setSwingHand(false);
                            event.setCanceled(true);
                        } else if (interactionResult == InteractionResult.PASS && ClientConfig.keyConflictResolveScope.cancelItemUse()) {
                            event.setSwingHand(false);
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }
}

