/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.grappling;

import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.LongHitAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.grappling.GrapplingAttackAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.MutableBoolean;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class GrapplingTryAnimation
extends AttackAnimation {
    private final AnimationManager.AnimationAccessor<? extends GrapplingAttackAnimation> grapplingAttackAnimation;
    private final AnimationManager.AnimationAccessor<? extends ActionAnimation> failAnimation;
    private final AnimationManager.AnimationAccessor<? extends LongHitAnimation> grapplingHitAnimation;

    public GrapplingTryAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends GrapplingTryAnimation> accessor, AnimationManager.AnimationAccessor<? extends LongHitAnimation> grapplingHitAnimation, AnimationManager.AnimationAccessor<? extends GrapplingAttackAnimation> grapplingAttackAnimation, AnimationManager.AnimationAccessor<? extends ActionAnimation> failAnimation, AssetAccessor<? extends Armature> armature) {
        this(convertTime, antic, preDelay, contact, recovery, InteractionHand.MAIN_HAND, collider, colliderJoint, accessor, grapplingHitAnimation, grapplingAttackAnimation, failAnimation, armature);
    }

    public GrapplingTryAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends GrapplingTryAnimation> accessor, AnimationManager.AnimationAccessor<? extends LongHitAnimation> grapplingHitAnimation, AnimationManager.AnimationAccessor<? extends GrapplingAttackAnimation> grapplingAttackAnimation, AnimationManager.AnimationAccessor<? extends ActionAnimation> failAnimation, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, accessor, armature);
        this.grapplingAttackAnimation = grapplingAttackAnimation;
        this.failAnimation = failAnimation;
        this.grapplingHitAnimation = grapplingHitAnimation;
        ((StaticAnimation)this).addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, Float.valueOf(0.0f));
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK, false);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, null);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, MoveCoordFunctions.TRACE_ORIGIN_AS_DESTINATION);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_GET, MoveCoordFunctions.WORLD_COORD);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.ENTITY_YROT_PROVIDER, MoveCoordFunctions.LOOK_DEST);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        LivingEntity hitEntity;
        super.begin(entitypatch);
        if (!entitypatch.isLogicalClient() && (hitEntity = entitypatch.getTarget()) != null) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)hitEntity, LivingEntityPatch.class).ifPresent(LivingEntityPatch::notifyGrapplingWarning);
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (isEnd && !entitypatch.isLogicalClient()) {
            float poseTime;
            AnimationPlayer player;
            float prevPoseTime;
            AttackAnimation.Phase phase;
            List<Entity> list;
            LivingEntity hitEntity = entitypatch.getTarget();
            MutableBoolean mb = new MutableBoolean(false);
            if (hitEntity != null && (list = (phase = this.getPhaseByTime(0.0f)).getCollidingEntities(entitypatch, this, prevPoseTime = (player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor())).getPrevElapsedTime(), poseTime = player.getElapsedTime(), this.getPlaySpeed(entitypatch, this))).contains(hitEntity)) {
                EpicFightDamageSource dmgSource = this.getEpicFightDamageSource(entitypatch, (Entity)hitEntity, phase);
                EpicFightCapabilities.getParameterizedEntityPatch((Entity)hitEntity, LivingEntity.class, LivingEntityPatch.class).ifPresentOrElse(hitEntityPatch -> {
                    if (hitEntityPatch.tryHurt((DamageSource)dmgSource, (float)0.0f).resultType.dealtDamage()) {
                        entitypatch.reserveAnimation(this.grapplingAttackAnimation);
                        entitypatch.setGrapplingTarget(hitEntity);
                        hitEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, ((LivingEntity)entitypatch.getOriginal()).m_20182_());
                        hitEntityPatch.playAnimationSynchronized(this.grapplingHitAnimation, 0.0f);
                        mb.set(true);
                    }
                }, () -> {
                    entitypatch.reserveAnimation(this.grapplingAttackAnimation);
                    entitypatch.setGrapplingTarget(hitEntity);
                    mb.set(true);
                });
            }
            if (!mb.value()) {
                entitypatch.reserveAnimation(this.failAnimation);
            }
        }
    }

    @Override
    protected void attackTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
    }
}

