/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.grappling;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class GrapplingAttackAnimation
extends AttackAnimation {
    public GrapplingAttackAnimation(float contact, float recovery, AnimationManager.AnimationAccessor<? extends GrapplingAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(contact, recovery, InteractionHand.MAIN_HAND, accessor, armature);
    }

    public GrapplingAttackAnimation(float contact, float recovery, InteractionHand hand, AnimationManager.AnimationAccessor<? extends GrapplingAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(0.0f, 0.0f, contact, contact, recovery, hand, null, armature.get().rootJoint, accessor, armature);
        ((StaticAnimation)this).addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, Float.valueOf(0.0f));
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK, false);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.RAW_COORD);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, null);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_GET, MoveCoordFunctions.ATTACHED);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        if (entitypatch.shouldMoveOnCurrentSide(this)) {
            Keyframe[] grapplingAnimCoord = ((TransformSheet)((Animator)entitypatch.getAnimator()).getVariables().getOrDefaultSharedVariable(ACTION_ANIMATION_COORD)).getKeyframes();
            Vec3f translation = grapplingAnimCoord[grapplingAnimCoord.length - 1].transform().translation();
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, 0.0, 0.0);
            ((LivingEntity)entitypatch.getOriginal()).m_146884_(translation.toDoubleVector());
        }
        super.begin(entitypatch);
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        entitypatch.setGrapplingTarget(null);
    }

    @Override
    protected void attackTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        LivingEntity grapplingTarget;
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor());
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = animation.get().getState(entitypatch, elapsedTime);
        EntityState prevState = animation.get().getState(entitypatch, prevElapsedTime);
        AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
        if ((prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) && (grapplingTarget = entitypatch.getGrapplingTarget()) != null) {
            EpicFightDamageSource source = this.getEpicFightDamageSource(entitypatch, (Entity)grapplingTarget, phase);
            source.setInitialPosition(null);
            int prevInvulTime = grapplingTarget.f_19802_;
            grapplingTarget.f_19802_ = 0;
            entitypatch.attack(source, (Entity)grapplingTarget, InteractionHand.MAIN_HAND);
            grapplingTarget.f_19802_ = prevInvulTime;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, float playTime, float partialTicks) {
    }
}

